/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Archive;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ArchivePath;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ArchivePaths;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.Asset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.FileAsset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.Validate;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnterpriseContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements EnterpriseContainer<T> {
    protected EnterpriseContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract ArchivePath getApplicationPath();

    @Override
    public T setApplicationXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setApplicationXML(new ClassLoaderAsset(resourceName));
    }

    @Override
    public T setApplicationXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new FileAsset(resource));
    }

    @Override
    public T setApplicationXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new UrlAsset(resource));
    }

    @Override
    public T setApplicationXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsApplicationResource(resource, "application.xml");
    }

    @Override
    public T setApplicationXML(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        return this.setApplicationXML(new ClassLoaderAsset(classloaderResourceName));
    }

    @Override
    public T addAsApplicationResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    @Override
    public T addAsApplicationResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), resource.getName());
    }

    @Override
    public T addAsApplicationResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    @Override
    public T addAsApplicationResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), target);
    }

    @Override
    public T addAsApplicationResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new UrlAsset(resource), target);
    }

    @Override
    public T addAsApplicationResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource(resource, (ArchivePath)new BasicPath(target));
    }

    @Override
    public T addAsApplicationResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    @Override
    public T addAsApplicationResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new FileAsset(resource), target);
    }

    @Override
    public T addAsApplicationResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource((Asset)new UrlAsset(resource), target);
    }

    @Override
    public T addAsApplicationResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getApplicationPath(), target);
        return this.add(resource, location);
    }

    @Override
    public T addAsApplicationResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsApplicationResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    @Override
    public T addAsApplicationResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create(classloaderResourceName);
        return this.addAsApplicationResource(resourcePackage, resourceName, target);
    }

    @Override
    public T addAsApplicationResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsApplicationResource(resourcePackage, resourceName, ArchivePaths.create(target));
    }

    @Override
    public T addAsApplicationResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsApplicationResource((Asset)resource, target);
    }

    protected abstract ArchivePath getModulePath();

    @Override
    public T addAsModule(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getModulePath(), ZipExporter.class);
    }

    @Override
    public T addAsModule(String resourceName) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        BasicPath location = new BasicPath(AssetUtil.getNameForClassloaderResource(resourceName));
        return this.addAsModule(resourceName, (ArchivePath)location);
    }

    @Override
    public T addAsModule(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsModule(resource, resource.getName());
    }

    @Override
    public T addAsModules(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "archives must be specified");
        for (Archive<?> archive : archives) {
            this.addAsModule(archive);
        }
        return this.covarientReturn();
    }

    @Override
    public T addAsModules(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "resourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addAsModule(resourceName);
        }
        return this.covarientReturn();
    }

    @Override
    public T addAsModules(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "resources must be specified");
        for (File resource : resources) {
            this.addAsModule(resource);
        }
        return this.covarientReturn();
    }

    @Override
    public T addAsModule(File resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        FileAsset asset = new FileAsset(resource);
        return this.addAsModule((Asset)asset, targetPath);
    }

    @Override
    public T addAsModule(String resourceName, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        ClassLoaderAsset asset = new ClassLoaderAsset(resourceName);
        return this.addAsModule((Asset)asset, targetPath);
    }

    @Override
    public T addAsModule(URL resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        UrlAsset asset = new UrlAsset(resource);
        return this.addAsModule((Asset)asset, targetPath);
    }

    @Override
    public T addAsModule(File resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    @Override
    public T addAsModule(Asset resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    @Override
    public T addAsModule(String resourceName, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resourceName, (ArchivePath)new BasicPath(targetPath));
    }

    @Override
    public T addAsModule(URL resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addAsModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    @Override
    public T addAsModule(Asset resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.add(resource, new BasicPath(this.getModulePath(), targetPath));
    }
}

