/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DatastoreEmulatorContainer
extends GenericContainer<DatastoreEmulatorContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"gcr.io/google.com/cloudsdktool/cloud-sdk");
    private static final String CMD = "gcloud beta emulators datastore start --project test-project --host-port 0.0.0.0:8081";
    private static final int HTTP_PORT = 8081;

    public DatastoreEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8081});
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/").forStatusCode(200));
        this.withCommand(new String[]{"/bin/sh", "-c", CMD});
    }

    public String getEmulatorEndpoint() {
        return this.getContainerIpAddress() + ":" + this.getMappedPort(8081);
    }
}

