/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dynamodb;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DynaliteContainer
extends GenericContainer<DynaliteContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"quay.io/testcontainers/dynalite");
    private static final String DEFAULT_TAG = "v1.2.1-1";
    private static final int MAPPED_PORT = 4567;

    @Deprecated
    public DynaliteContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public DynaliteContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public DynaliteContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{4567});
    }

    public AmazonDynamoDB getClient() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(this.getEndpointConfiguration())).withCredentials(this.getCredentials())).build();
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration() {
        return new AwsClientBuilder.EndpointConfiguration("http://" + this.getHost() + ":" + this.getMappedPort(4567), null);
    }

    public AWSCredentialsProvider getCredentials() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("dummy", "dummy"));
    }
}

