/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dynamodb;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.testcontainers.containers.GenericContainer;

public class DynaliteContainer
extends GenericContainer<DynaliteContainer> {
    private static final String IMAGE_NAME = "quay.io/testcontainers/dynalite:v1.2.1-1";
    private static final int MAPPED_PORT = 4567;

    public DynaliteContainer() {
        this(IMAGE_NAME);
        this.withExposedPorts(new Integer[]{4567});
    }

    public DynaliteContainer(String imageName) {
        super(imageName);
    }

    public AmazonDynamoDB getClient() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(this.getEndpointConfiguration())).withCredentials(this.getCredentials())).build();
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration() {
        return new AwsClientBuilder.EndpointConfiguration("http://" + this.getHost() + ":" + this.getMappedPort(4567), null);
    }

    public AWSCredentialsProvider getCredentials() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("dummy", "dummy"));
    }
}

