/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.databend;

import java.util.HashSet;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DatabendContainer
extends JdbcDatabaseContainer<DatabendContainer> {
    static final String NAME = "databend";
    static final DockerImageName DOCKER_IMAGE_NAME = DockerImageName.parse((String)"datafuselabs/databend");
    private static final Integer HTTP_PORT = 8000;
    private static final String DRIVER_CLASS_NAME = "com.databend.jdbc.DatabendDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:databend://";
    private static final String TEST_QUERY = "SELECT 1";
    private String databaseName = "default";
    private String username = "databend";
    private String password = "databend";

    public DatabendContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public DatabendContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DOCKER_IMAGE_NAME});
        this.addExposedPorts(new int[]{HTTP_PORT});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/").forResponsePredicate(response -> response.equals("Ok.")));
    }

    protected void configure() {
        this.withEnv("QUERY_DEFAULT_USER", this.username);
        this.withEnv("QUERY_DEFAULT_PASSWORD", this.password);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return new HashSet<Integer>(this.getMappedPort(HTTP_PORT));
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getJdbcUrl() {
        return JDBC_URL_PREFIX + this.getHost() + ":" + this.getMappedPort(HTTP_PORT) + "/" + this.databaseName + this.constructUrlParameters("?", "&");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTestQueryString() {
        return TEST_QUERY;
    }

    public DatabendContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public DatabendContainer withPassword(String password) {
        this.password = password;
        return this;
    }
}

