/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ClickHouseContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "clickhouse";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"yandex/clickhouse-server");
    @Deprecated
    public static final String IMAGE = DEFAULT_IMAGE_NAME.getUnversionedPart();
    @Deprecated
    public static final String DEFAULT_TAG = "18.10.3";
    public static final Integer HTTP_PORT = 8123;
    public static final Integer NATIVE_PORT = 9000;
    private static final String DRIVER_CLASS_NAME = "ru.yandex.clickhouse.ClickHouseDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:clickhouse://";
    private static final String TEST_QUERY = "SELECT 1";
    private String databaseName = "default";
    private String username = "default";
    private String password = "";

    @Deprecated
    public ClickHouseContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public ClickHouseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ClickHouseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{HTTP_PORT, NATIVE_PORT});
        this.waitingFor(new HttpWaitStrategy().forStatusCode(200).forResponsePredicate(responseBody -> "Ok.".equals(responseBody)).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(HTTP_PORT);
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getJdbcUrl() {
        return JDBC_URL_PREFIX + this.getHost() + ":" + this.getMappedPort(HTTP_PORT) + "/" + this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return TEST_QUERY;
    }

    public ClickHouseContainer withUrlParam(String paramName, String paramValue) {
        throw new UnsupportedOperationException("The ClickHouse does not support this");
    }
}

