/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.chromadb;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ChromaDBContainer
extends GenericContainer<ChromaDBContainer> {
    private static final DockerImageName DEFAULT_DOCKER_IMAGE = DockerImageName.parse((String)"chromadb/chroma");
    private static final DockerImageName GHCR_DOCKER_IMAGE = DockerImageName.parse((String)"ghcr.io/chroma-core/chroma");

    public ChromaDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ChromaDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_DOCKER_IMAGE, GHCR_DOCKER_IMAGE});
        this.withExposedPorts(new Integer[]{8000});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/api/v1/heartbeat"));
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getFirstMappedPort();
    }
}

