/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.azure;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;

public class ServiceBusEmulatorContainer
extends GenericContainer<ServiceBusEmulatorContainer> {
    private static final String CONNECTION_STRING_FORMAT = "Endpoint=sb://%s:%d;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=SAS_KEY_VALUE;UseDevelopmentEmulator=true;";
    private static final int DEFAULT_PORT = 5672;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mcr.microsoft.com/azure-messaging/servicebus-emulator");
    private MSSQLServerContainer<?> msSqlServerContainer;

    public ServiceBusEmulatorContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ServiceBusEmulatorContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{5672});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Emulator Service is Successfully Up!.*", (int)1));
    }

    public ServiceBusEmulatorContainer withMsSqlServerContainer(MSSQLServerContainer<?> msSqlServerContainer) {
        this.dependsOn(new Startable[]{msSqlServerContainer});
        this.msSqlServerContainer = msSqlServerContainer;
        return this;
    }

    public ServiceBusEmulatorContainer withConfig(Transferable config) {
        this.withCopyToContainer(config, "/ServiceBus_Emulator/ConfigFiles/Config.json");
        return this;
    }

    public ServiceBusEmulatorContainer acceptLicense() {
        this.withEnv("ACCEPT_EULA", "Y");
        return this;
    }

    protected void configure() {
        if (this.msSqlServerContainer == null) {
            throw new IllegalStateException("The image " + this.getDockerImageName() + " requires a Microsoft SQL Server container. Please provide one with the withMsSqlServerContainer method!");
        }
        this.withEnv("SQL_SERVER", (String)this.msSqlServerContainer.getNetworkAliases().get(0));
        this.withEnv("MSSQL_SA_PASSWORD", this.msSqlServerContainer.getPassword());
        if (!this.getEnvMap().containsKey("ACCEPT_EULA")) {
            LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
            this.acceptLicense();
        }
    }

    public String getConnectionString() {
        return String.format(CONNECTION_STRING_FORMAT, this.getHost(), this.getMappedPort(5672));
    }
}

