/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.properties;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.test4j.generator.properties.LeafNode;
import org.test4j.tools.commons.TextBuilder;

final class JavaGenerator {
    private static final String Properties_Klass_Surfix = "Properties";
    private String klassName;
    private Map<String, Object> children = new TreeMap<String, Object>();

    JavaGenerator(String klassName) {
        this.klassName = klassName;
    }

    final void addKeys(String[] subKeys, String fullKey, String value) {
        String subKey = subKeys[0];
        if (subKeys.length == 1) {
            this.children.put(subKey, new LeafNode(fullKey, value));
        } else {
            if (!this.children.containsKey(subKey)) {
                this.children.put(subKey, new JavaGenerator(this.klassName(subKey)));
            }
            ((JavaGenerator)this.children.get(subKey)).addKeys(Arrays.copyOfRange(subKeys, 1, subKeys.length), fullKey, value);
        }
    }

    private String klassName(String key) {
        return key.substring(0, 1).toUpperCase() + key.substring(1) + Properties_Klass_Surfix;
    }

    final String toJavaStr(boolean root, String tab) {
        TextBuilder klass = new TextBuilder().append("\n%spublic %sclass %s {", new Object[]{tab, root ? "" : "static ", this.klassName});
        TextBuilder construct = new TextBuilder().append("\n\n%s\t%s(Environment env) {", new Object[]{tab, this.klassName});
        if (root) {
            klass.append("\n\tpublic static %s config;\n", new Object[]{this.klassName});
        }
        for (Map.Entry<String, Object> entry : this.children.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LeafNode) {
                LeafNode node = (LeafNode)value;
                String keyType = node.getKeyType();
                klass.append("\n%s\tpublic final %s %s;", new Object[]{tab, keyType, key});
                construct.append("\n%s\t\tthis.%s = new %s(env, \"%s\");", new Object[]{tab, key, keyType, node.getFullKey()});
                continue;
            }
            String klassName = ((JavaGenerator)value).klassName;
            klass.append("\n%s\tpublic final %s %s;", new Object[]{tab, klassName, key});
            construct.append("\n%s\t\tthis.%s = new %s(env);", new Object[]{tab, key, klassName});
        }
        if (root) {
            construct.append("\n\t\t%s.config = this;", new Object[]{this.klassName});
        }
        construct.append("\n\t%s}", new Object[]{tab});
        klass.append(construct);
        for (Map.Entry<String, Object> entry : this.children.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof JavaGenerator)) continue;
            String java = ((JavaGenerator)value).toJavaStr(false, tab + "\t");
            klass.append("\n" + java, new Object[0]);
        }
        klass.append("\n%s}", new Object[]{tab});
        return klass.toString();
    }
}

