/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.properties;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.test4j.generator.properties.ConfigGeneratorHelper;
import org.test4j.generator.properties.JavaGenerator;
import org.test4j.tools.commons.TextBuilder;

public class ConfigGenerator {
    private static final List<String> filter_keys = Arrays.asList("");
    public final Map<String, String> properties = new TreeMap<String, String>();

    public static ConfigGenerator env(String env) throws Exception {
        return new ConfigGenerator("application.yml", "application-" + env + ".yml");
    }

    public ConfigGenerator(String ... files) throws Exception {
        this(ConfigGeneratorHelper.parseFiles(files));
    }

    public ConfigGenerator(Properties properties) {
        Enumeration<?> it = properties.propertyNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            this.properties.put(key, properties.getProperty(key));
        }
    }

    public ConfigGenerator(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public String generate(Class klass) {
        return this.generate(klass.getPackage().getName(), klass.getSimpleName());
    }

    public String generate(String packageName, String klassName) {
        JavaGenerator generator = new JavaGenerator(klassName);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (filter_keys.contains(key)) continue;
            String[] items = key.split("\\.");
            generator.addKeys(items, key, entry.getValue());
        }
        TextBuilder appender = new TextBuilder().newLine().append("package %s;", new Object[]{packageName}).newLine(2).append("import org.springframework.core.env.Environment;", new Object[0]).newLine().append("import org.springframework.stereotype.Component;", new Object[0]).newLine().append("@Component", new Object[0]).append(generator.toJavaStr(true, ""), new Object[0]);
        return appender.toString();
    }
}

