/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test4j.generator.config.IGlobalConfig;
import org.test4j.generator.impl.BaseTemplateGenerator;
import org.test4j.generator.template.BaseTemplate;
import org.test4j.generator.template.DataMapTemplateList;
import org.test4j.generator.template.summary.SummaryTemplate;

public class GeneratorByApi
extends BaseTemplateGenerator {
    private static final Logger log = LoggerFactory.getLogger(GeneratorByApi.class);
    private boolean withTest = false;
    private boolean withEntity = false;

    public static IGlobalConfig build(boolean withEntity, boolean withTest) {
        if (!withEntity && !withTest) {
            throw new RuntimeException("\u751f\u6210Entity\u548cTest\u8f85\u52a9\u7c7b\u4e0d\u80fd\u540c\u65f6\u4e3a\u5047");
        }
        GeneratorByApi generator = new GeneratorByApi();
        generator.withTest = withTest;
        generator.withEntity = withEntity;
        return generator;
    }

    @Override
    protected void generateSummary(List<Map<String, Object>> allContext) {
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put("configs", allContext);
        wrapper.put("basePackage", this.globalConfig.getBasePackage());
        if (!this.withTest) {
            return;
        }
        for (SummaryTemplate summary : DataMapTemplateList.summaries) {
            summary.setGlobalConfig(this.globalConfig);
            this.templateEngine.output(summary.getTemplateId(), wrapper, summary.getFilePath());
        }
    }

    @Override
    protected List<BaseTemplate> getAllTemplates() {
        ArrayList<BaseTemplate> list = new ArrayList<BaseTemplate>();
        if (this.withTest) {
            list.addAll(DataMapTemplateList.test_list);
        }
        if (this.withEntity) {
            list.addAll(DataMapTemplateList.entity_list);
        }
        return list;
    }
}

