/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test4j.generator.config.IGlobalConfig;
import org.test4j.generator.config.IGlobalConfigSet;
import org.test4j.generator.config.ITableConfig;
import org.test4j.generator.config.ITableConfigSet;
import org.test4j.generator.config.impl.GlobalConfig;
import org.test4j.generator.config.impl.TableConfigSet;
import org.test4j.generator.config.impl.TableSetter;
import org.test4j.generator.engine.AbstractTemplateEngine;
import org.test4j.generator.engine.VelocityTemplateEngine;
import org.test4j.generator.template.BaseTemplate;
import org.test4j.hamcrest.Assert;
import org.test4j.module.core.utility.MessageHelper;
import org.test4j.tools.commons.StringHelper;

public abstract class BaseTemplateGenerator
implements IGlobalConfig,
ITableConfig {
    private static final Logger log = LoggerFactory.getLogger(BaseTemplateGenerator.class);
    protected AbstractTemplateEngine templateEngine = new VelocityTemplateEngine();
    protected List<TableConfigSet> tableConfigs = new ArrayList<TableConfigSet>();
    protected GlobalConfig globalConfig;

    @Override
    public ITableConfig globalConfig(Consumer<IGlobalConfigSet> consumer) {
        this.globalConfig = new GlobalConfig();
        consumer.accept(this.globalConfig);
        return this;
    }

    @Override
    public ITableConfig tables(Consumer<ITableConfigSet> consumer) {
        TableConfigSet tableConfig = new TableConfigSet(this.globalConfig);
        consumer.accept(tableConfig);
        this.tables(tableConfig);
        return this;
    }

    public ITableConfig tables(ITableConfigSet ... tableConfigs) {
        for (ITableConfigSet tableConfig : tableConfigs) {
            this.tableConfigs.add((TableConfigSet)tableConfig);
        }
        return this;
    }

    protected abstract List<BaseTemplate> getAllTemplates();

    @Override
    public void execute() {
        if (this.globalConfig == null) {
            throw new RuntimeException("the global config not set.");
        }
        if (this.tableConfigs == null || this.tableConfigs.isEmpty()) {
            throw new RuntimeException("the table config not set.");
        }
        ArrayList<Map<String, Object>> allContext = new ArrayList<Map<String, Object>>();
        for (TableConfigSet config : this.tableConfigs) {
            MessageHelper.info((Object)"===\u6570\u636e\u5e93\u5143\u4fe1\u606f\u521d\u59cb\u5316...", (Throwable[])new Throwable[0]);
            config.initTables();
            MessageHelper.info((Object)"===\u51c6\u5907\u751f\u6210\u6587\u4ef6...", (Throwable[])new Throwable[0]);
            for (Map.Entry<String, TableSetter> entry : config.getTables().entrySet()) {
                MessageHelper.info((Object)("======\u5904\u7406\u8868\uff1a" + entry.getKey()), (Throwable[])new Throwable[0]);
                TableSetter table = entry.getValue();
                Map<String, Object> context = this.getAllTemplateContext(table);
                this.generateTemplates(table, context);
                allContext.add(context);
            }
            MessageHelper.info((Object)"===\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01", (Throwable[])new Throwable[0]);
        }
        this.generateSummary(allContext);
        this.open();
    }

    protected void generateSummary(List<Map<String, Object>> allContext) {
    }

    private void generateTemplates(TableSetter table, Map<String, Object> context) {
        for (BaseTemplate template : this.getAllTemplates()) {
            if (template.isPartition() && !table.isPartition()) continue;
            String filePath = template.getFilePath();
            String key = template.getTemplateId() + "." + "overWrite";
            String overwrite = BaseTemplate.getConfig(context, key, Boolean.TRUE.toString());
            File file = new File(filePath);
            if (!Boolean.valueOf(overwrite).booleanValue() && file.exists()) {
                MessageHelper.info((Object)("=========\u8df3\u8fc7\u6587\u4ef6[" + file.getName() + "], \u6587\u4ef6\u5df2\u7ecf\u5b58\u5728, \u6839\u636e\u914d\u7f6e\u8df3\u8fc7\u91cd\u5199"), (Throwable[])new Throwable[0]);
                continue;
            }
            MessageHelper.info((Object)("=========\u751f\u6210\u6587\u4ef6[" + file.getName() + "]"), (Throwable[])new Throwable[0]);
            Assert.notNull((Object)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a,[table=%s,template=%s]", (Object[])new Object[]{table.getTableName(), template.getTemplate()});
            this.templateEngine.output(template.getTemplate(), context, filePath);
        }
    }

    private Map<String, Object> getAllTemplateContext(TableSetter table) {
        Map<String, Object> context = table.initTemplateContext();
        this.getAllTemplates().forEach(template -> {
            HashMap<String, Object> templateContext = new HashMap<String, Object>();
            context.put(template.getTemplateId(), templateContext);
            template.initContext(table, context, templateContext);
            if ("entity".equals(template.getTemplateId())) {
                context.put("entityName", templateContext.get("name"));
            }
        });
        return context;
    }

    private void open() {
        try {
            String osName;
            if (this.globalConfig.isOpen() && !StringHelper.isBlank((String)this.globalConfig.getOutputDir()) && (osName = System.getProperty("os.name")) != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + this.globalConfig.getOutputDir());
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + this.globalConfig.getOutputDir());
                } else {
                    log.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + this.globalConfig.getOutputDir());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<TableConfigSet> getTableConfigs() {
        return this.tableConfigs;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public BaseTemplateGenerator setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }
}

