/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.engine;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test4j.generator.engine.AbstractTemplateEngine;
import org.test4j.tools.commons.StringHelper;

public class VelocityTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(VelocityTemplateEngine.class);
    private VelocityEngine velocityEngine;

    @Override
    public VelocityTemplateEngine init() {
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("file.resource.loader.path", "");
            p.setProperty("UTF-8", UTF8);
            p.setProperty("input.encoding", UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    @Override
    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringHelper.isBlank((String)templatePath)) {
            return;
        }
        Template template = this.velocityEngine.getTemplate(templatePath, UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        log.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }
}

