/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.engine;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.test4j.generator.engine.AbstractTemplateEngine;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerTemplateEngine.class);
    private Configuration configuration;

    @Override
    public FreemarkerTemplateEngine init() {
        this.configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.configuration.setDefaultEncoding(UTF8);
        this.configuration.setClassForTemplateLoading(FreemarkerTemplateEngine.class, "/");
        return this;
    }

    @Override
    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        Template template = this.configuration.getTemplate(templatePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, UTF8));
        }
        log.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }
}

