/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.test4j.functions.EConsumer;
import org.test4j.functions.EFunction;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.script.DBHelper;
import org.test4j.tools.commons.ResourceHelper;

public class SqlRunner {
    public static void execute(DBEnvironment env, String sql) {
        env.execute(sql, (EConsumer<PreparedStatement>)((EConsumer & Serializable)PreparedStatement::execute));
    }

    public static void executeFromFile(DBEnvironment env, String fileName) {
        String[] statements;
        for (String statement : statements = DBHelper.parseSQL(ResourceHelper.readFromFile((String)fileName))) {
            SqlRunner.execute(env, statement);
        }
    }

    public static void executeFromFile(DBEnvironment env, Class klass, String fileName) {
        try {
            String[] statements;
            for (String statement : statements = DBHelper.parseSQL(ResourceHelper.readFromFile((Class)klass, (String)fileName))) {
                SqlRunner.execute(env, statement);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeFromStream(DBEnvironment env, InputStream is) {
        String[] statements;
        for (String statement : statements = DBHelper.parseSQL(ResourceHelper.readFromStream((InputStream)is))) {
            SqlRunner.execute(env, statement);
        }
    }

    public static <T> T query(DBEnvironment env, String sql, Class<T> claz) {
        return (T)env.query(sql, (EFunction & Serializable)resultSet -> {
            if (Map.class.isAssignableFrom(claz)) {
                return DBHelper.getMapFromResult(resultSet, false);
            }
            return DBHelper.getPoJoFromResult(resultSet, claz);
        });
    }

    public static <T> List<T> queryList(DBEnvironment env, String sql, Class<T> clazz) {
        return (List)env.query(sql, (EFunction & Serializable)resultSet -> {
            if (Map.class.isAssignableFrom(clazz)) {
                return DBHelper.getListMapFromResult(resultSet, false);
            }
            return DBHelper.getListPoJoFromResult(resultSet, clazz);
        });
    }

    public static <T> List<T> queryMapList(DBEnvironment env, String sql) {
        return (List)env.query(sql, (EFunction & Serializable)resultSet -> DBHelper.getListMapFromResult(resultSet, false));
    }

    public static <T> List<T> queryMapList(DBEnvironment env, String sql, Map<String, Object> where) {
        return (List)env.query((EFunction<Connection, PreparedStatement>)(EFunction & Serializable)connection -> {
            PreparedStatement st = connection.prepareStatement(sql);
            return SqlRunner.setParameterByMap(st, where);
        }, (EFunction & Serializable)resultSet -> DBHelper.getListMapFromResult(resultSet, false));
    }

    public static Map<String, Object> queryMap(DBEnvironment env, String sql) {
        List list = SqlRunner.queryMapList(env, sql);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("to many result, u want to query one RowSet.");
        }
        return (Map)list.get(0);
    }

    private static PreparedStatement setParameterByMap(PreparedStatement st, Map<String, Object> where) {
        int index = 1;
        for (Map.Entry<String, Object> entry : where.entrySet()) {
            try {
                Object value = entry.getValue();
                if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    st.setBinaryStream(index, is, is.available());
                } else {
                    st.setObject(index, value);
                }
                ++index;
            }
            catch (Throwable e) {
                throw new RuntimeException("set column[" + entry.getKey() + "] value error:" + e.getMessage(), e);
            }
        }
        return st;
    }
}

