/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import java.util.Optional;
import org.test4j.module.database.proxy.SqlContext;
import org.test4j.module.database.proxy.SqlList;

public class Test4JSqlContext {
    private static final ThreadLocal<SqlList> sqlContext = new ThreadLocal();
    private static final ThreadLocal<Boolean> hasRecord = new ThreadLocal();
    private static final ThreadLocal<Boolean> IN_DB_OPERATOR = new ThreadLocal();

    public static void setRecordStatus(boolean status) {
        hasRecord.set(status);
    }

    public static void setDbOpStatus(boolean status) {
        IN_DB_OPERATOR.set(status);
    }

    public static void setNextRecordStatus() {
        hasRecord.set(false);
    }

    public static boolean needRecord() {
        return !Test4JSqlContext.isRecord() && !Test4JSqlContext.isTestOp();
    }

    public static SqlList getSqlContext() {
        return Optional.ofNullable(sqlContext.get()).orElseGet(() -> {
            SqlList list = new SqlList();
            sqlContext.set(list);
            return list;
        });
    }

    public static void addSql(String sql, Object ... parameters) {
        Test4JSqlContext.getSqlContext().add(new SqlContext(sql, parameters));
        Test4JSqlContext.setRecordStatus(true);
    }

    public static void clean() {
        Test4JSqlContext.getSqlContext().clear();
    }

    private static boolean isRecord() {
        return hasRecord.get() != null && hasRecord.get() != false;
    }

    private static boolean isTestOp() {
        return IN_DB_OPERATOR.get() != null && IN_DB_OPERATOR.get() != false;
    }
}

