/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.test4j.hamcrest.IWant;
import org.test4j.hamcrest.base.Assert;
import org.test4j.module.database.IDataSourceScript;
import org.test4j.module.database.config.DbConfig;
import org.test4j.tools.commons.StringHelper;

public class DataSourceScriptHelper {
    static Map<String, Boolean> DATASOURCE_SCRIPT_HAS_INIT = new HashMap<String, Boolean>();

    public static void runInitScripts(DataSource dataSource, String beanName) {
        DataSourceScriptHelper.runInitScripts(dataSource, beanName, null);
    }

    public static void runInitScripts(DataSource dataSource, String beanName, DbType dbType) {
        boolean hasRun;
        if (dataSource == null || DATASOURCE_SCRIPT_HAS_INIT.containsKey(beanName)) {
            return;
        }
        IDataSourceScript factory = DbConfig.instance().dbScriptFactory(beanName);
        if (factory == null) {
            hasRun = DataSourceScriptHelper.runFromClasspathResource(dataSource, beanName);
        } else {
            DbType type = dbType == null ? DbConfig.instance().dbType(beanName) : dbType;
            hasRun = DataSourceScriptHelper.runFromScriptFactory(type, dataSource, factory);
        }
        if (hasRun) {
            DataSourceScriptHelper.commitScript(dataSource);
        }
        DATASOURCE_SCRIPT_HAS_INIT.put(beanName, true);
    }

    private static void commitScript(DataSource dataSource) {
        try {
            if (!dataSource.getConnection().getAutoCommit()) {
                dataSource.getConnection().commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("commit datasource script error:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runFromScriptFactory(DbType type, DataSource dataSource, IDataSourceScript factory) {
        String script = factory.script(type);
        try {
            IWant.want.string(script).notNull("script can't be null.");
            Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
            try {
                InputStreamResource resource = new InputStreamResource((InputStream)new ByteArrayInputStream(script.getBytes()));
                ScriptUtils.executeSqlScript((Connection)connection, (EncodedResource)new EncodedResource((Resource)resource, "utf-8"), (boolean)false, (boolean)true, (String)"--", (String)";", (String)"/*", (String)"*/");
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute database script:\n\t" + script + "\n\n", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runFromClasspathResource(DataSource dataSource, String beanName) {
        List<Resource> resources = DataSourceScriptHelper.getResources(beanName);
        if (resources.isEmpty()) {
            return false;
        }
        Assert.notNull((Object)dataSource, (String)"DataSource must be provided.", (Object[])new Object[0]);
        try {
            Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
            IWant.want.object((Object)connection).notNull("connection must be null.");
            try {
                for (Resource resource : resources) {
                    ScriptUtils.executeSqlScript((Connection)connection, (EncodedResource)new EncodedResource(resource, "utf-8"), (boolean)false, (boolean)true, (String)"--", (String)";", (String)"/*", (String)"*/");
                }
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute database script", e);
        }
    }

    private static List<Resource> getResources(String beanName) {
        String[] locations = DbConfig.instance().dbScript(beanName);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            if (StringHelper.isBlank((String)location)) continue;
            ClassPathResource resource = new ClassPathResource(location);
            if (resource.exists()) {
                resources.add((Resource)resource);
                continue;
            }
            throw new RuntimeException("The specified resource[" + beanName + "] does not exist.");
        }
        return resources;
    }
}

