/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.proxy.DataSourceMariaDb4jCreator;
import org.test4j.module.database.proxy.DataSourceScriptHelper;
import org.test4j.module.database.proxy.EmbeddedMysqlConfig;
import org.test4j.module.database.proxy.IDataSourceCreator;
import org.test4j.module.database.proxy.Test4JDataSource;

public class DataSourceCreator {
    public static Map<String, Test4JDataSource> EXIST_DATASOURCE = new HashMap<String, Test4JDataSource>();

    public static DataSource create(String scriptSourceName, DbType dbType, String driver, String url, String username, String password) {
        return DataSourceCreator.create(scriptSourceName, dbType, driver, url, username, password, null);
    }

    public static DataSource create(String scriptSourceName, DbType dbType, String driver, String url, String username, String password, String schema) {
        if (EXIST_DATASOURCE.containsKey(url)) {
            return EXIST_DATASOURCE.get(url);
        }
        IDataSourceCreator dataSourceFactory = DbConfig.instance().dbCreator(scriptSourceName);
        String _driver = driver == null ? dbType.feature.getDriver() : driver;
        DataSource ds = dataSourceFactory.createDataSource(_driver, url, username, password, schema);
        Test4JDataSource dataSource = new Test4JDataSource(scriptSourceName, ds);
        EXIST_DATASOURCE.put(url, dataSource);
        DataSourceScriptHelper.runInitScripts(dataSource, scriptSourceName, dbType);
        return dataSource;
    }

    public static DataSource create(String dataSourceName) {
        if (EXIST_DATASOURCE.containsKey(dataSourceName)) {
            return EXIST_DATASOURCE.get(dataSourceName);
        }
        Test4JDataSource dataSource = DataSourceCreator.createDataSource(dataSourceName);
        EXIST_DATASOURCE.put(dataSourceName, dataSource);
        DataSourceScriptHelper.runInitScripts(dataSource, dataSourceName);
        return dataSource;
    }

    private static Test4JDataSource createDataSource(String dataSourceName) {
        DataSource ds;
        DbType dbType = DbConfig.instance().dbType(dataSourceName);
        if (dbType == DbType.MARIADB) {
            return DataSourceMariaDb4jCreator.createTest4JDataSource(dataSourceName);
        }
        if (dbType == DbType.MYSQL && DbConfig.instance().embeddedMysqlEnable()) {
            EmbeddedMysqlConfig config = new EmbeddedMysqlConfig().start();
            ds = DataSourceCreator.create(dataSourceName, DbType.MYSQL, "com.mysql.jdbc.Driver", config.url(), config.userName, config.password, config.schema);
        } else {
            IDataSourceCreator dataSourceFactory = DbConfig.instance().dbCreator(dataSourceName);
            ds = dataSourceFactory.createDataSource(dataSourceName);
        }
        return ds instanceof Test4JDataSource ? (Test4JDataSource)ds : new Test4JDataSource(dataSourceName, ds);
    }
}

