/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.operator;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.test4j.Logger;
import org.test4j.exception.Exceptions;
import org.test4j.exception.ExtraMessageError;
import org.test4j.hamcrest.iassert.impl.CollectionAssert;
import org.test4j.hamcrest.iassert.intf.ICollectionAssert;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.datagen.TableData;
import org.test4j.module.database.datagen.TableMap;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.enviroment.DBEnvironmentFactory;
import org.test4j.module.database.operator.IDBOperator;
import org.test4j.module.database.operator.ISqlSet;
import org.test4j.module.database.operator.ITableOp;
import org.test4j.module.database.operator.TableOp;
import org.test4j.module.database.proxy.SqlList;
import org.test4j.module.database.proxy.Test4JSqlContext;
import org.test4j.module.database.script.SqlRunner;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.datagen.IDataMap;

public class DBOperator
implements IDBOperator {
    private final String dataSourceName;

    public DBOperator() {
        this.dataSourceName = DbConfig.instance().defaultDataSource();
    }

    public DBOperator(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    private DBEnvironment env() {
        return DBEnvironmentFactory.getDBEnvironment(this.dataSourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator cleanTable(String table, String ... more) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            this.table(table).clean();
            for (String item : more) {
                this.table(item).clean();
            }
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public IDBOperator execute(String sql) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            SqlRunner.execute(this.env(), sql);
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public IDBOperator execute(File file) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            try {
                SqlRunner.executeFromStream(this.env(), new FileInputStream(file));
            }
            catch (Exception e) {
                throw Exceptions.wrapWithRuntimeException((Throwable)e);
            }
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public IDBOperator commit() {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            this.env().commit();
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public IDBOperator rollback() {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            this.env().rollback();
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert query(String sql) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            List list = SqlRunner.queryMapList(this.env(), sql);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public ITableOp table(String table) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            TableOp tableOp = new TableOp(this.env(), table);
            return tableOp;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public IDBOperator execute(ISqlSet sqlSet) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            if (sqlSet == null) {
                throw new RuntimeException("the insert sqlSet can't be null.");
            }
            sqlSet.execute(this.env());
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> returnList(String query, Class pojoClazz) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String _query = query.trim();
            if (!_query.toLowerCase().startsWith("select")) {
                _query = "select * from " + query;
            }
            if (pojoClazz == null) {
                List<Object> list = SqlRunner.queryMapList(this.env(), query);
                return list;
            }
            List<Object> list = SqlRunner.queryList(this.env(), _query, pojoClazz);
            return list;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    private void deleteWhere(String table) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String sql = "delete from " + table;
            SqlRunner.execute(this.env(), sql);
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public SqlList sqlList() {
        return Test4JSqlContext.getSqlContext();
    }

    @Override
    public String printAsDataMap(String tableAndWhere, String mapName) {
        List<Map<String, Object>> list = TableOp.queryData(this.env(), tableAndWhere);
        boolean isDefault = StringHelper.isBlank((String)mapName);
        StringBuilder buff = new StringBuilder("\n").append(isDefault ? "DataMap" : mapName).append(".create(").append(list.size()).append(")");
        HashMap data = new HashMap(20);
        for (Map<String, Object> map : list) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String value;
                String key = entry.getKey();
                String string = value = entry.getValue() == null ? "null" : "\"" + entry.getValue() + "\"";
                if (!data.containsKey(key)) {
                    data.put(key, new ArrayList());
                }
                ((List)data.get(key)).add(value);
            }
        }
        for (Map.Entry entry : data.entrySet()) {
            String value = String.join((CharSequence)", ", (Iterable)entry.getValue());
            if (!value.contains("\"")) continue;
            if (isDefault) {
                buff.append("\n\t.kv(").append("\"").append((String)entry.getKey()).append("\"").append(", ").append(value).append(")");
                continue;
            }
            buff.append("\n\t.").append((String)entry.getKey()).append(".values(").append(value).append(")");
        }
        String text = buff.toString();
        Logger.info((Object)text, (Throwable[])new Throwable[0]);
        return text;
    }

    @Override
    public void printAsJson(String ... tables) {
        this.printAsJson(tables, new String[0], new String[0]);
    }

    @Override
    public String printAsJson(String[] tables, String[] orderColumns, String ... excludes) {
        TableMap map = new TableMap();
        for (String table : tables) {
            TableData data = this.findTableData(table, orderColumns, excludes);
            map.put(table, data);
        }
        String text = IKit.json.toJSON((Object)map, true);
        Logger.info((Object)("\n" + text + "\n"), (Throwable[])new Throwable[0]);
        return text;
    }

    private TableData findTableData(String tableAndWhere, String[] orderColumns, String[] excludes) {
        List _excludes = ListHelper.toList((Object[])excludes);
        List _columns = ListHelper.toList((Object[])orderColumns);
        List<Map<String, Object>> list = TableOp.queryData(this.env(), tableAndWhere);
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>(list.size());
        for (Map<String, Object> data : list) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(data.size());
            if (data.containsKey("id") && !_excludes.contains("id")) {
                map.put("id", StringHelper.toJsonString((Object)data.get("id")));
            }
            for (String string : _columns) {
                if (!data.containsKey(string) || map.containsKey(string)) continue;
                map.put(string, StringHelper.toJsonString((Object)data.get(string)));
            }
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                if (map.containsKey(key) || _excludes.contains(key)) continue;
                map.put(key, StringHelper.toJsonString(entry.getValue()));
            }
            records.add(map);
        }
        return new TableData((List<Map<String, Object>>)records);
    }

    @Override
    public String insert(TableMap data, boolean clean) {
        StringBuilder buff = new StringBuilder();
        try {
            for (Map.Entry entry : data.entrySet()) {
                String table = (String)entry.getKey();
                IDataMap records = ((TableData)entry.getValue()).findDataMap();
                if (clean) {
                    this.deleteWhere(table);
                    buff.append("\t\u6e05\u7a7a\u8868[").append(table).append("]\u6570\u636e\n");
                }
                buff.append("\t\u51c6\u5907[").append(records.getRowSize()).append("]\u6761[").append(table).append("]\u8868\u6570\u636e\n");
                this.table(table).insert(records);
            }
            return buff.toString();
        }
        catch (Throwable e) {
            throw new ExtraMessageError(buff.toString(), e);
        }
    }

    @Override
    public String queryEq(TableMap data) {
        StringBuilder buff = new StringBuilder();
        try {
            for (Map.Entry entry : data.entrySet()) {
                String query = (String)entry.getKey();
                if (!query.trim().toLowerCase().startsWith("select")) {
                    query = "select * from " + query;
                }
                IDataMap records = ((TableData)entry.getValue()).findDataMap();
                try {
                    buff.append("\t\u68c0\u67e5[").append(query).append("]\u6570\u636e, \u603b[").append(records.getRowSize()).append("]\u6761\u6570\u636e\n");
                    this.query(query).eqDataMap(records, new EqMode[]{EqMode.IGNORE_DEFAULTS, EqMode.IGNORE_ORDER, EqMode.EQ_STRING});
                }
                catch (AssertionError error) {
                    String message = ((Throwable)((Object)error)).getMessage();
                    throw new AssertionError((Object)("[" + query + "] data assert fail: " + message));
                }
            }
            return buff.toString();
        }
        catch (Throwable e) {
            throw new ExtraMessageError(buff.toString(), e);
        }
    }
}

