/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.mocker;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.test4j.annotations.Mock;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;
import org.test4j.mock.startup.Startup;
import org.test4j.module.database.proxy.Test4JSqlContext;
import org.test4j.tools.commons.StringHelper;

public class MybatisConfigurationMock
extends MockUp<Configuration> {
    static boolean hasMock = false;
    static boolean classNotFound = false;

    private MybatisConfigurationMock() {
        hasMock = true;
    }

    @Mock
    public StatementHandler newStatementHandler(Invocation it, Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        StatementHandler statementHandler = (StatementHandler)it.proceed(new Object[]{executor, mappedStatement, parameterObject, rowBounds, resultHandler, boundSql});
        BoundSql sql = boundSql;
        if (sql == null) {
            sql = mappedStatement.getSqlSource().getBoundSql(parameterObject);
        }
        if (sql != null) {
            TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
            Object[] parameters = this.getParameters((Configuration)it.getTarget(), sql, typeHandlerRegistry);
            Test4JSqlContext.addSql(StringHelper.removeBreakingWhiteSpace((String)sql.getSql()), parameters);
        }
        return statementHandler;
    }

    private Object[] getParameters(Configuration configuration, BoundSql boundSql, TypeHandlerRegistry typeHandlerRegistry) {
        if (boundSql.getParameterMappings() == null) {
            return null;
        }
        return boundSql.getParameterMappings().stream().filter(this::isInParameter).map(parameterMapping -> this.parseParameterValue(configuration, typeHandlerRegistry, boundSql, (ParameterMapping)parameterMapping)).toArray();
    }

    private boolean isInParameter(ParameterMapping parameterMapping) {
        return parameterMapping.getMode() != ParameterMode.OUT;
    }

    private Object parseParameterValue(Configuration configuration, TypeHandlerRegistry typeHandlerRegistry, BoundSql boundSql, ParameterMapping parameterMapping) {
        Object parameterObject = boundSql.getParameterObject();
        String propertyName = parameterMapping.getProperty();
        if (boundSql.hasAdditionalParameter(propertyName)) {
            return boundSql.getAdditionalParameter(propertyName);
        }
        if (parameterObject == null) {
            return null;
        }
        if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
            return parameterObject;
        }
        MetaObject metaObject = configuration.newMetaObject(parameterObject);
        return metaObject.getValue(propertyName);
    }

    public static void mockMybatisConfiguration() {
        if (hasMock || classNotFound) {
            return;
        }
        try {
            Class.forName("org.apache.ibatis.session.Configuration");
        }
        catch (ClassNotFoundException e) {
            classNotFound = true;
            return;
        }
        Startup.initializing = true;
        new MybatisConfigurationMock();
        Startup.initializing = false;
    }
}

