/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.test4j.module.database.script.DBHelper;
import org.test4j.module.database.script.EntityScriptParser;

public interface IDataSourceScript {
    public static final Map<String, String> SPEC_TYPES = new HashMap<String, String>();

    public List<Class> getTableKlass();

    public IndexList getIndexList();

    default public String script(DbType type) {
        String script = EntityScriptParser.script(type, this.dbTypeConvert(), this.getTableKlass());
        String index = IndexList.script(this.getIndexList());
        return script + "\n\n" + index;
    }

    default public EntityScriptParser.DbTypeConvert dbTypeConvert() {
        if (SPEC_TYPES.size() == 0) {
            return EntityScriptParser.NonDbTypeConvert.INSTANCE;
        }
        return type -> {
            String _type = type.toLowerCase();
            return SPEC_TYPES.getOrDefault(_type, _type);
        };
    }

    default public <T> List<T> list(T ... objs) {
        ArrayList list = new ArrayList(objs.length);
        Collections.addAll(list, objs);
        return list;
    }

    public static class IndexList {
        List<Index> indexList = new ArrayList<Index>();

        public IndexList unique(String table, String ... columns) {
            this.indexList.add(new Index().setUnique(true).setTable(table).setColumns(columns));
            return this;
        }

        public IndexList index(String table, String ... columns) {
            this.indexList.add(new Index().setUnique(false).setTable(table).setColumns(columns));
            return this;
        }

        public static String script(IndexList indexList) {
            if (indexList == null || indexList.indexList == null || indexList.indexList.size() == 0) {
                return "";
            }
            return indexList.indexList.stream().map(Index::buildIndex).collect(Collectors.joining("\n"));
        }
    }

    public static class Index {
        private boolean isUnique;
        private String table;
        private String[] columns;

        public String buildIndex() {
            return this.isUnique ? DBHelper.buildH2Unique(this.table, this.columns) : DBHelper.buildH2Index(this.table, this.columns);
        }

        public boolean isUnique() {
            return this.isUnique;
        }

        public String getTable() {
            return this.table;
        }

        public String[] getColumns() {
            return this.columns;
        }

        public Index setUnique(boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public Index setTable(String table) {
            this.table = table;
            return this;
        }

        public Index setColumns(String[] columns) {
            this.columns = columns;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUnique() != other.isUnique()) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            return Arrays.deepEquals(this.getColumns(), other.getColumns());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Index;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUnique() ? 79 : 97);
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getColumns());
            return result;
        }

        public String toString() {
            return "IDataSourceScript.Index(isUnique=" + this.isUnique() + ", table=" + this.getTable() + ", columns=" + Arrays.deepToString(this.getColumns()) + ")";
        }
    }
}

