/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database;

import java.lang.reflect.Method;
import java.util.List;
import org.test4j.module.Test4JListener;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.enviroment.DBEnvironmentFactory;
import org.test4j.module.database.mocker.MybatisConfigurationMock;
import org.test4j.module.database.proxy.DataSourceCreator;
import org.test4j.module.database.proxy.Test4JSqlContext;
import org.test4j.module.spring.SpringEnv;

public class DatabaseListener
implements Test4JListener {
    public boolean init() {
        MybatisConfigurationMock.mockMybatisConfiguration();
        return true;
    }

    public void beforeAll(Class testClazz) {
        if (!SpringEnv.isSpringEnv()) {
            return;
        }
        List<String> dataSources = DbConfig.instance().dataSourceList();
        for (String dataSourceName : dataSources) {
            DataSourceCreator.create(dataSourceName);
        }
    }

    public void afterAll() {
    }

    public void beforeMethod(Object target) {
    }

    public void beforeExecute(Object testObject, Method testMethod) {
        Test4JSqlContext.clean();
    }

    public void afterExecute(Object testObject, Method testMethod, Throwable testThrowable) {
    }

    public void afterMethod() {
        DBEnvironmentFactory.closeDBEnvironment();
        Test4JSqlContext.clean();
    }
}

