/*
 * Decompiled with CFR 0.152.
 */
package org.terrakube.client.dex;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.crypto.SecretKey;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrakube.client.dex.DexCredentialType;

public class DexCredentialAuthentication
implements Authenticator,
Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DexCredentialAuthentication.class);
    private static final String ISSUER = "TerrakubeInternal";
    private static final String SUBJECT = "TerrakubeInternal (TOKEN)";
    private static final String EMAIL = "no-reply@terrakube.org";
    private static final String NAME = "TerrakubeInternal Client";
    private String secretKey;
    private String accessToken = "";
    private DexCredentialType dexCredentialType;

    public DexCredentialAuthentication(String secretKey, DexCredentialType dexCredentialType) {
        this.secretKey = secretKey;
        this.dexCredentialType = dexCredentialType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request authenticate(Route route, Response response) {
        log.info("Authentication error {}", (Object)response.code());
        DexCredentialAuthentication dexCredentialAuthentication = this;
        synchronized (dexCredentialAuthentication) {
            this.accessToken = this.generateAccessToken();
        }
        return this.newRequestWithAccessToken(response.request(), this.accessToken);
    }

    @NonNull
    private Request newRequestWithAccessToken(@NonNull Request request, String accessToken) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return request.newBuilder().header("Authorization", "Bearer " + accessToken).build();
    }

    private String generateAccessToken() {
        log.error("Generate Dex Authentication Private Token");
        String newToken = "";
        if (this.dexCredentialType.equals((Object)DexCredentialType.INTERNAL)) {
            SecretKey key = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64URL.decode((Object)this.secretKey)));
            newToken = ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuer(ISSUER)).setSubject(SUBJECT)).setAudience(ISSUER)).claim("email", (Object)EMAIL).claim("email_verified", (Object)true).claim("name", (Object)NAME).setIssuedAt(Date.from(Instant.now()))).setExpiration(Date.from(Instant.now().plus(30L, ChronoUnit.DAYS)))).signWith((Key)key).compact();
        } else {
            newToken = this.secretKey;
        }
        return newToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = this.newRequestWithAccessToken(chain.request(), this.accessToken);
        Response response = chain.proceed(request);
        if (response.code() == 401 || response.code() == 403) {
            DexCredentialAuthentication dexCredentialAuthentication = this;
            synchronized (dexCredentialAuthentication) {
                return chain.proceed(this.newRequestWithAccessToken(request, this.generateAccessToken()));
            }
        }
        return response;
    }
}

