/*
 * Decompiled with CFR 0.152.
 */
package org.terrakube.client;

import feign.Headers;
import feign.Param;
import feign.RequestLine;
import java.util.List;
import org.terrakube.client.model.organization.Organization;
import org.terrakube.client.model.organization.job.Job;
import org.terrakube.client.model.organization.job.JobRequest;
import org.terrakube.client.model.organization.job.step.Step;
import org.terrakube.client.model.organization.job.step.StepRequest;
import org.terrakube.client.model.organization.module.Module;
import org.terrakube.client.model.organization.module.ModuleRequest;
import org.terrakube.client.model.organization.provider.version.Version;
import org.terrakube.client.model.organization.provider.version.implementation.Implementation;
import org.terrakube.client.model.organization.ssh.Ssh;
import org.terrakube.client.model.organization.template.Template;
import org.terrakube.client.model.organization.vcs.Vcs;
import org.terrakube.client.model.organization.workspace.Workspace;
import org.terrakube.client.model.organization.workspace.history.HistoryRequest;
import org.terrakube.client.model.organization.workspace.variable.Variable;
import org.terrakube.client.model.response.Response;
import org.terrakube.client.model.response.ResponseWithInclude;

public interface TerrakubeClient {
    @RequestLine(value="GET /api/v1/organization")
    public Response<List<Organization>> getAllOrganizations();

    @RequestLine(value="GET /api/v1/organization?filter[job]=status=={jobStatus}&include=job")
    public ResponseWithInclude<List<Organization>, Job> getAllOrganizationsWithJobStatus(@Param(value="jobStatus") String var1);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace/{workspaceId}/variable?filter[variable]=sensitive==true;category==terraform")
    public Response<List<Variable>> getAllSecrets(@Param(value="organizationId") String var1, @Param(value="workspaceId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace/{workspaceId}/variable?filter[variable]=sensitive==false;category==terraform")
    public Response<List<Variable>> getAllVariables(@Param(value="organizationId") String var1, @Param(value="workspaceId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace/{workspaceId}/variable?filter[variable]=category==env")
    public Response<List<Variable>> getAllEnvironmentVariables(@Param(value="organizationId") String var1, @Param(value="workspaceId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace")
    public Response<List<Workspace>> getAllWorkspaces(@Param(value="organizationId") String var1);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace/{workspaceId}")
    public Response<Workspace> getWorkspaceById(@Param(value="organizationId") String var1, @Param(value="workspaceId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/workspace/{workspaceId}?include=variable")
    public ResponseWithInclude<Workspace, Variable> getWorkspaceByIdWithVariables(@Param(value="organizationId") String var1, @Param(value="workspaceId") String var2);

    @RequestLine(value="PATCH /api/v1/organization/{organizationId}/job/{jobId}")
    @Headers(value={"Content-Type: application/vnd.api+json"})
    public void updateJob(JobRequest var1, @Param(value="organizationId") String var2, @Param(value="jobId") String var3);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/job/{jobId}?include=step")
    public ResponseWithInclude<Job, Step> getJobById(@Param(value="organizationId") String var1, @Param(value="jobId") String var2);

    @RequestLine(value="POST /api/v1/organization/{organizationId}/job/{jobId}/step")
    @Headers(value={"Content-Type: application/vnd.api+json"})
    public void createStep(StepRequest var1, @Param(value="organizationId") String var2, @Param(value="jobId") String var3);

    @RequestLine(value="POST /api/v1/organization/{organizationId}/workspace/{workspaceId}/history")
    @Headers(value={"Content-Type: application/vnd.api+json"})
    public void createHistory(HistoryRequest var1, @Param(value="organizationId") String var2, @Param(value="workspaceId") String var3);

    @RequestLine(value="PATCH /api/v1/organization/{organizationId}/job/{jobId}/step/{stepId}")
    @Headers(value={"Content-Type: application/vnd.api+json"})
    public void updateStep(StepRequest var1, @Param(value="organizationId") String var2, @Param(value="jobId") String var3, @Param(value="stepId") String var4);

    @RequestLine(value="GET /api/v1/organization?filter[organization]=name=={organizationName}")
    public Response<List<Organization>> getOrganizationByName(@Param(value="organizationName") String var1);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/module?filter[module]=name=={moduleName};provider=={providerName}")
    public Response<List<Module>> getModuleByNameAndProvider(@Param(value="organizationId") String var1, @Param(value="moduleName") String var2, @Param(value="providerName") String var3);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/module/{moduleId}")
    public Response<Module> getModuleById(@Param(value="organizationId") String var1, @Param(value="moduleId") String var2);

    @RequestLine(value="PATCH /api/v1/organization/{organizationId}/module/{moduleId}")
    @Headers(value={"Content-Type: application/vnd.api+json"})
    public void updateModule(ModuleRequest var1, @Param(value="organizationId") String var2, @Param(value="moduleId") String var3);

    @RequestLine(value="GET /api/v1/organization?filter[organization]=name=={organizationName}&filter[provider]=name=={providerName}")
    public Response<List<Organization>> getOrganizationsByNameAndProvider(@Param(value="organizationName") String var1, @Param(value="providerName") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/provider/{providerId}/version?include=implementation")
    public ResponseWithInclude<List<Version>, Implementation> getAllVersionsByProviderWithImplementation(@Param(value="organizationId") String var1, @Param(value="providerId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/provider/{providerId}/version?filter[version]=versionNumber=={versionNumber}")
    public Response<List<Version>> getVersionsByOrganizationIdAndProviderIdAndVersionNumber(@Param(value="organizationId") String var1, @Param(value="providerId") String var2, @Param(value="versionNumber") String var3);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/provider/{providerId}/version/{versionId}/implementation?filter[implementation]=os=={os};arch=={arch}")
    public Response<List<Implementation>> getImplementationByOsArchVersion(@Param(value="organizationId") String var1, @Param(value="providerId") String var2, @Param(value="versionId") String var3, @Param(value="os") String var4, @Param(value="arch") String var5);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/vcs/{vcsId}")
    public Response<Vcs> getVcsById(@Param(value="organizationId") String var1, @Param(value="vcsId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/ssh/{sshId}")
    public Response<Ssh> getSshById(@Param(value="organizationId") String var1, @Param(value="sshId") String var2);

    @RequestLine(value="GET /api/v1/organization/{organizationId}/template/{templateId}")
    public Response<Template> getTemplateById(@Param(value="organizationId") String var1, @Param(value="templateId") String var2);
}

