/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import org.tensorflow.lite.TensorImpl;

final class NativeSignatureRunnerWrapper {
    private final long signatureRunnerHandle;
    private final long errorHandle;
    private boolean isMemoryAllocated = false;

    NativeSignatureRunnerWrapper(long interpreterHandle, long errorHandle, String signatureKey) {
        this.errorHandle = errorHandle;
        this.signatureRunnerHandle = NativeSignatureRunnerWrapper.nativeGetSignatureRunner(interpreterHandle, signatureKey);
        if (this.signatureRunnerHandle == -1L) {
            throw new IllegalArgumentException("Input error: Signature " + signatureKey + " not found.");
        }
    }

    public int getSubgraphIndex() {
        return NativeSignatureRunnerWrapper.nativeGetSubgraphIndex(this.signatureRunnerHandle);
    }

    public String[] inputNames() {
        return NativeSignatureRunnerWrapper.nativeInputNames(this.signatureRunnerHandle);
    }

    public String[] outputNames() {
        return NativeSignatureRunnerWrapper.nativeOutputNames(this.signatureRunnerHandle);
    }

    public TensorImpl getInputTensor(String inputName) {
        return TensorImpl.fromSignatureInput(this.signatureRunnerHandle, inputName);
    }

    public TensorImpl getOutputTensor(String outputName) {
        return TensorImpl.fromSignatureOutput(this.signatureRunnerHandle, outputName);
    }

    public int getInputIndex(String inputName) {
        int inputIndex = NativeSignatureRunnerWrapper.nativeGetInputIndex(this.signatureRunnerHandle, inputName);
        if (inputIndex == -1) {
            throw new IllegalArgumentException("Input error: input " + inputName + " not found.");
        }
        return inputIndex;
    }

    public int getOutputIndex(String outputName) {
        int outputIndex = NativeSignatureRunnerWrapper.nativeGetOutputIndex(this.signatureRunnerHandle, outputName);
        if (outputIndex == -1) {
            throw new IllegalArgumentException("Input error: output " + outputName + " not found.");
        }
        return outputIndex;
    }

    public boolean resizeInput(String inputName, int[] dims) {
        this.isMemoryAllocated = false;
        return NativeSignatureRunnerWrapper.nativeResizeInput(this.signatureRunnerHandle, this.errorHandle, inputName, dims);
    }

    public void allocateTensorsIfNeeded() {
        if (this.isMemoryAllocated) {
            return;
        }
        NativeSignatureRunnerWrapper.nativeAllocateTensors(this.signatureRunnerHandle, this.errorHandle);
        this.isMemoryAllocated = true;
    }

    public void invoke() {
        NativeSignatureRunnerWrapper.nativeInvoke(this.signatureRunnerHandle, this.errorHandle);
    }

    private static native long nativeGetSignatureRunner(long var0, String var2);

    private static native int nativeGetSubgraphIndex(long var0);

    private static native String[] nativeInputNames(long var0);

    private static native String[] nativeOutputNames(long var0);

    private static native int nativeGetInputIndex(long var0, String var2);

    private static native int nativeGetOutputIndex(long var0, String var2);

    private static native boolean nativeResizeInput(long var0, long var2, String var4, int[] var5);

    private static native void nativeAllocateTensors(long var0, long var2);

    private static native void nativeInvoke(long var0, long var2);
}

