/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.Tensor;
import org.tensorflow.lite.TensorFlowLite;
import org.tensorflow.lite.nnapi.NnApiDelegate;

final class NativeInterpreterWrapper
implements AutoCloseable {
    private static final int ERROR_BUFFER_SIZE = 512;
    private long errorHandle;
    private long interpreterHandle;
    private long modelHandle;
    private long cancellationFlagHandle = 0L;
    private long inferenceDurationNanoseconds = -1L;
    private ByteBuffer modelByteBuffer;
    private Map<String, Integer> inputsIndexes;
    private Map<String, Integer> outputsIndexes;
    private Map<Integer, Integer> tensorToInputsIndexes;
    private Map<Integer, Integer> tensorToOutputsIndexes;
    private Tensor[] inputTensors;
    private Tensor[] outputTensors;
    private boolean isMemoryAllocated = false;
    private final List<Delegate> delegates = new ArrayList<Delegate>();
    private final List<AutoCloseable> ownedDelegates = new ArrayList<AutoCloseable>();

    NativeInterpreterWrapper(String modelPath) {
        this(modelPath, null);
    }

    NativeInterpreterWrapper(ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    NativeInterpreterWrapper(String modelPath, Interpreter.Options options) {
        TensorFlowLite.init();
        long errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        long modelHandle = NativeInterpreterWrapper.createModel(modelPath, errorHandle);
        this.init(errorHandle, modelHandle, options);
    }

    NativeInterpreterWrapper(ByteBuffer buffer, Interpreter.Options options) {
        TensorFlowLite.init();
        if (buffer == null || !(buffer instanceof MappedByteBuffer) && (!buffer.isDirect() || buffer.order() != ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Model ByteBuffer should be either a MappedByteBuffer of the model file, or a direct ByteBuffer using ByteOrder.nativeOrder() which contains bytes of model content.");
        }
        this.modelByteBuffer = buffer;
        long errorHandle = NativeInterpreterWrapper.createErrorReporter(512);
        long modelHandle = NativeInterpreterWrapper.createModelWithBuffer(this.modelByteBuffer, errorHandle);
        this.init(errorHandle, modelHandle, options);
    }

    private void init(long errorHandle, long modelHandle, Interpreter.Options options) {
        if (options == null) {
            options = new Interpreter.Options();
        }
        this.errorHandle = errorHandle;
        this.modelHandle = modelHandle;
        this.interpreterHandle = NativeInterpreterWrapper.createInterpreter(modelHandle, errorHandle, options.numThreads);
        if (options.allowCancellation != null && options.allowCancellation.booleanValue()) {
            this.cancellationFlagHandle = NativeInterpreterWrapper.createCancellationFlag(this.interpreterHandle);
        }
        this.inputTensors = new Tensor[NativeInterpreterWrapper.getInputCount(this.interpreterHandle)];
        this.outputTensors = new Tensor[NativeInterpreterWrapper.getOutputCount(this.interpreterHandle)];
        if (options.allowFp16PrecisionForFp32 != null) {
            NativeInterpreterWrapper.allowFp16PrecisionForFp32(this.interpreterHandle, options.allowFp16PrecisionForFp32);
        }
        if (options.allowBufferHandleOutput != null) {
            NativeInterpreterWrapper.allowBufferHandleOutput(this.interpreterHandle, options.allowBufferHandleOutput);
        }
        this.applyDelegates(options);
        int applyXNNPACKMode = -1;
        if (options.useXNNPACK != null) {
            int n = applyXNNPACKMode = options.useXNNPACK != false ? 1 : 0;
        }
        if (applyXNNPACKMode == 1) {
            NativeInterpreterWrapper.useXNNPACK(this.interpreterHandle, errorHandle, applyXNNPACKMode, options.numThreads);
        }
        NativeInterpreterWrapper.allocateTensors(this.interpreterHandle, errorHandle);
        this.isMemoryAllocated = true;
    }

    @Override
    public void close() {
        int i;
        for (i = 0; i < this.inputTensors.length; ++i) {
            if (this.inputTensors[i] == null) continue;
            this.inputTensors[i].close();
            this.inputTensors[i] = null;
        }
        for (i = 0; i < this.outputTensors.length; ++i) {
            if (this.outputTensors[i] == null) continue;
            this.outputTensors[i].close();
            this.outputTensors[i] = null;
        }
        NativeInterpreterWrapper.delete(this.errorHandle, this.modelHandle, this.interpreterHandle);
        NativeInterpreterWrapper.deleteCancellationFlag(this.cancellationFlagHandle);
        this.errorHandle = 0L;
        this.modelHandle = 0L;
        this.interpreterHandle = 0L;
        this.cancellationFlagHandle = 0L;
        this.modelByteBuffer = null;
        this.inputsIndexes = null;
        this.outputsIndexes = null;
        this.isMemoryAllocated = false;
        this.delegates.clear();
        for (AutoCloseable ownedDelegate : this.ownedDelegates) {
            try {
                ownedDelegate.close();
            }
            catch (Exception e) {
                System.err.println("Failed to close flex delegate: " + e);
            }
        }
        this.ownedDelegates.clear();
    }

    public void runSignature(Map<String, Object> inputs, Map<String, Object> outputs, String methodName) {
        int tensorIndex;
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("Input error: Inputs should not be null or empty.");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Input error: Outputs should not be null.");
        }
        this.initTensorIndexesMaps();
        TreeMap<Integer, Object> inputsWithInputIndex = new TreeMap<Integer, Object>();
        TreeMap<Integer, Object> outputsWithOutputIndex = new TreeMap<Integer, Object>();
        for (Map.Entry<String, Object> input : inputs.entrySet()) {
            tensorIndex = NativeInterpreterWrapper.getInputTensorIndexFromSignature(this.interpreterHandle, input.getKey(), methodName);
            inputsWithInputIndex.put(this.tensorToInputsIndexes.get(tensorIndex), input.getValue());
        }
        for (Map.Entry<String, Object> output : outputs.entrySet()) {
            tensorIndex = NativeInterpreterWrapper.getOutputTensorIndexFromSignature(this.interpreterHandle, output.getKey(), methodName);
            outputsWithOutputIndex.put(this.tensorToOutputsIndexes.get(tensorIndex), output.getValue());
        }
        Object[] inputsList = new Object[inputs.size()];
        int index = 0;
        for (Map.Entry input : inputsWithInputIndex.entrySet()) {
            inputsList[index++] = input.getValue();
        }
        this.run(inputsList, outputsWithOutputIndex);
    }

    void run(Object[] inputs, Map<Integer, Object> outputs) {
        boolean needsAllocation;
        this.inferenceDurationNanoseconds = -1L;
        if (inputs == null || inputs.length == 0) {
            throw new IllegalArgumentException("Input error: Inputs should not be null or empty.");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Input error: Outputs should not be null.");
        }
        for (int i = 0; i < inputs.length; ++i) {
            Tensor tensor = this.getInputTensor(i);
            int[] newShape = tensor.getInputShapeIfDifferent(inputs[i]);
            if (newShape == null) continue;
            this.resizeInput(i, newShape);
        }
        boolean bl = needsAllocation = !this.isMemoryAllocated;
        if (needsAllocation) {
            NativeInterpreterWrapper.allocateTensors(this.interpreterHandle, this.errorHandle);
            this.isMemoryAllocated = true;
        }
        for (int i = 0; i < inputs.length; ++i) {
            this.getInputTensor(i).setTo(inputs[i]);
        }
        long inferenceStartNanos = System.nanoTime();
        NativeInterpreterWrapper.run(this.interpreterHandle, this.errorHandle);
        long inferenceDurationNanoseconds = System.nanoTime() - inferenceStartNanos;
        if (needsAllocation) {
            for (int i = 0; i < this.outputTensors.length; ++i) {
                if (this.outputTensors[i] == null) continue;
                this.outputTensors[i].refreshShape();
            }
        }
        for (Map.Entry<Integer, Object> output : outputs.entrySet()) {
            if (output.getValue() == null) continue;
            this.getOutputTensor(output.getKey()).copyTo(output.getValue());
        }
        this.inferenceDurationNanoseconds = inferenceDurationNanoseconds;
    }

    private static native void run(long var0, long var2);

    void resizeInput(int idx, int[] dims) {
        this.resizeInput(idx, dims, false);
    }

    void resizeInput(int idx, int[] dims, boolean strict) {
        if (NativeInterpreterWrapper.resizeInput(this.interpreterHandle, this.errorHandle, idx, dims, strict)) {
            this.isMemoryAllocated = false;
            if (this.inputTensors[idx] != null) {
                this.inputTensors[idx].refreshShape();
            }
        }
    }

    private static native boolean resizeInput(long var0, long var2, int var4, int[] var5, boolean var6);

    void allocateTensors() {
        if (this.isMemoryAllocated) {
            return;
        }
        this.isMemoryAllocated = true;
        NativeInterpreterWrapper.allocateTensors(this.interpreterHandle, this.errorHandle);
        for (int i = 0; i < this.outputTensors.length; ++i) {
            if (this.outputTensors[i] == null) continue;
            this.outputTensors[i].refreshShape();
        }
    }

    private static native long allocateTensors(long var0, long var2);

    void resetVariableTensors() {
        NativeInterpreterWrapper.resetVariableTensors(this.interpreterHandle, this.errorHandle);
    }

    int getInputIndex(String name) {
        if (this.inputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getInputNames(this.interpreterHandle);
            this.inputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.inputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.inputsIndexes.containsKey(name)) {
            return this.inputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any input. Names of inputs and their indexes are %s", name, this.inputsIndexes));
    }

    private void initTensorIndexesMaps() {
        if (this.tensorToInputsIndexes != null) {
            return;
        }
        this.tensorToInputsIndexes = new HashMap<Integer, Integer>();
        this.tensorToOutputsIndexes = new HashMap<Integer, Integer>();
        int inputCount = this.getInputTensorCount();
        for (int i = 0; i < inputCount; ++i) {
            int tensorIndex = NativeInterpreterWrapper.getInputTensorIndex(this.interpreterHandle, i);
            this.tensorToInputsIndexes.put(tensorIndex, i);
        }
        int outputCount = this.getOutputTensorCount();
        for (int i = 0; i < outputCount; ++i) {
            int tensorIndex = NativeInterpreterWrapper.getOutputTensorIndex(this.interpreterHandle, i);
            this.tensorToOutputsIndexes.put(tensorIndex, i);
        }
    }

    int getOutputIndex(String name) {
        if (this.outputsIndexes == null) {
            String[] names = NativeInterpreterWrapper.getOutputNames(this.interpreterHandle);
            this.outputsIndexes = new HashMap<String, Integer>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.outputsIndexes.put(names[i], i);
                }
            }
        }
        if (this.outputsIndexes.containsKey(name)) {
            return this.outputsIndexes.get(name);
        }
        throw new IllegalArgumentException(String.format("Input error: '%s' is not a valid name for any output. Names of outputs and their indexes are %s", name, this.outputsIndexes));
    }

    Long getLastNativeInferenceDurationNanoseconds() {
        return this.inferenceDurationNanoseconds < 0L ? null : Long.valueOf(this.inferenceDurationNanoseconds);
    }

    int getInputTensorCount() {
        return this.inputTensors.length;
    }

    Tensor getInputTensor(int index) {
        if (index < 0 || index >= this.inputTensors.length) {
            throw new IllegalArgumentException("Invalid input Tensor index: " + index);
        }
        Tensor inputTensor = this.inputTensors[index];
        if (inputTensor == null) {
            inputTensor = this.inputTensors[index] = Tensor.fromIndex(this.interpreterHandle, NativeInterpreterWrapper.getInputTensorIndex(this.interpreterHandle, index));
        }
        return inputTensor;
    }

    Tensor getInputTensor(String inputName, String methodName) {
        if (inputName == null) {
            throw new IllegalArgumentException("Invalid input tensor name provided (null)");
        }
        this.initTensorIndexesMaps();
        int tensorIndex = NativeInterpreterWrapper.getInputTensorIndexFromSignature(this.interpreterHandle, inputName, methodName);
        if (!this.tensorToInputsIndexes.containsKey(tensorIndex)) {
            throw new IllegalArgumentException(String.format("Invalid input tensor name (%s) for signature (%s).", inputName, methodName));
        }
        return this.getInputTensor(this.tensorToInputsIndexes.get(tensorIndex));
    }

    public String[] getSignatureDefNames() {
        return NativeInterpreterWrapper.getSignatureDefNames(this.interpreterHandle);
    }

    private static native String[] getSignatureDefNames(long var0);

    String[] getSignatureInputs(String methodName) {
        return NativeInterpreterWrapper.getSignatureInputs(this.interpreterHandle, methodName);
    }

    private static native String[] getSignatureInputs(long var0, String var2);

    String[] getSignatureOutputs(String methodName) {
        return NativeInterpreterWrapper.getSignatureOutputs(this.interpreterHandle, methodName);
    }

    private static native String[] getSignatureOutputs(long var0, String var2);

    int getOutputTensorCount() {
        return this.outputTensors.length;
    }

    Tensor getOutputTensor(int index) {
        if (index < 0 || index >= this.outputTensors.length) {
            throw new IllegalArgumentException("Invalid output Tensor index: " + index);
        }
        Tensor outputTensor = this.outputTensors[index];
        if (outputTensor == null) {
            outputTensor = this.outputTensors[index] = Tensor.fromIndex(this.interpreterHandle, NativeInterpreterWrapper.getOutputTensorIndex(this.interpreterHandle, index));
        }
        return outputTensor;
    }

    Tensor getOutputTensor(String outputName, String methodName) {
        if (outputName == null) {
            throw new IllegalArgumentException("Invalid output tensor name provided (null)");
        }
        this.initTensorIndexesMaps();
        int tensorIndex = NativeInterpreterWrapper.getOutputTensorIndexFromSignature(this.interpreterHandle, outputName, methodName);
        if (!this.tensorToOutputsIndexes.containsKey(tensorIndex)) {
            throw new IllegalArgumentException(String.format("Invalid output tensor name (%s) for signature (%s).", outputName, methodName));
        }
        return this.getOutputTensor(this.tensorToOutputsIndexes.get(tensorIndex));
    }

    int getExecutionPlanLength() {
        return NativeInterpreterWrapper.getExecutionPlanLength(this.interpreterHandle);
    }

    void setCancelled(boolean value) {
        if (this.cancellationFlagHandle == 0L) {
            throw new IllegalStateException("Cannot cancel the inference. Have you called Interpreter.Options.setCancellable?");
        }
        NativeInterpreterWrapper.setCancelled(this.interpreterHandle, this.cancellationFlagHandle, value);
    }

    private static native void setCancelled(long var0, long var2, boolean var4);

    private void applyDelegates(Interpreter.Options options) {
        Object optionalFlexDelegate;
        boolean originalGraphHasUnresolvedFlexOp = NativeInterpreterWrapper.hasUnresolvedFlexOp(this.interpreterHandle);
        if (originalGraphHasUnresolvedFlexOp && (optionalFlexDelegate = NativeInterpreterWrapper.maybeCreateFlexDelegate(options.delegates)) != null) {
            this.ownedDelegates.add((AutoCloseable)optionalFlexDelegate);
            NativeInterpreterWrapper.applyDelegate(this.interpreterHandle, this.errorHandle, optionalFlexDelegate.getNativeHandle());
        }
        try {
            for (Delegate delegate : options.delegates) {
                NativeInterpreterWrapper.applyDelegate(this.interpreterHandle, this.errorHandle, delegate.getNativeHandle());
                this.delegates.add(delegate);
            }
            if (options.useNNAPI != null && options.useNNAPI.booleanValue()) {
                NnApiDelegate optionalNnApiDelegate = new NnApiDelegate();
                this.ownedDelegates.add(optionalNnApiDelegate);
                NativeInterpreterWrapper.applyDelegate(this.interpreterHandle, this.errorHandle, optionalNnApiDelegate.getNativeHandle());
            }
        }
        catch (IllegalArgumentException e) {
            boolean shouldSuppressException;
            boolean bl = shouldSuppressException = originalGraphHasUnresolvedFlexOp && !NativeInterpreterWrapper.hasUnresolvedFlexOp(this.interpreterHandle);
            if (!shouldSuppressException) {
                throw e;
            }
            System.err.println("Ignoring failed delegate application: " + e);
        }
    }

    private static Delegate maybeCreateFlexDelegate(List<Delegate> delegates) {
        try {
            Class<?> clazz = Class.forName("org.tensorflow.lite.flex.FlexDelegate");
            for (Delegate delegate : delegates) {
                if (!clazz.isInstance(delegate)) continue;
                return null;
            }
            return (Delegate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static native int getOutputDataType(long var0, int var2);

    private static native boolean hasUnresolvedFlexOp(long var0);

    private static native int getInputTensorIndex(long var0, int var2);

    private static native int getInputTensorIndexFromSignature(long var0, String var2, String var3);

    private static native int getOutputTensorIndexFromSignature(long var0, String var2, String var3);

    private static native int getOutputTensorIndex(long var0, int var2);

    private static native int getInputCount(long var0);

    private static native int getOutputCount(long var0);

    private static native int getExecutionPlanLength(long var0);

    private static native String[] getInputNames(long var0);

    private static native String[] getOutputNames(long var0);

    private static native void allowFp16PrecisionForFp32(long var0, boolean var2);

    private static native void allowBufferHandleOutput(long var0, boolean var2);

    private static native void useXNNPACK(long var0, long var2, int var4, int var5);

    private static native long createErrorReporter(int var0);

    private static native long createModel(String var0, long var1);

    private static native long createModelWithBuffer(ByteBuffer var0, long var1);

    private static native long createInterpreter(long var0, long var2, int var4);

    private static native void applyDelegate(long var0, long var2, long var4);

    private static native void resetVariableTensors(long var0, long var2);

    private static native long createCancellationFlag(long var0);

    private static native long deleteCancellationFlag(long var0);

    private static native void delete(long var0, long var2, long var4);
}

