/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.DataTypeUtils;
import org.tensorflow.lite.Tensor;

final class TensorImpl
implements Tensor {
    private long nativeHandle;
    private final DataType dtype;
    private int[] shapeCopy;
    private final int[] shapeSignatureCopy;
    private final Tensor.QuantizationParams quantizationParamsCopy;

    static TensorImpl fromIndex(long nativeInterpreterHandle, int tensorIndex) {
        return new TensorImpl(TensorImpl.create(nativeInterpreterHandle, tensorIndex, 0));
    }

    static TensorImpl fromSignatureInput(long signatureRunnerHandle, String inputName) {
        return new TensorImpl(TensorImpl.createSignatureInputTensor(signatureRunnerHandle, inputName));
    }

    static TensorImpl fromSignatureOutput(long signatureRunnerHandle, String outputName) {
        return new TensorImpl(TensorImpl.createSignatureOutputTensor(signatureRunnerHandle, outputName));
    }

    void close() {
        TensorImpl.delete(this.nativeHandle);
        this.nativeHandle = 0L;
    }

    public DataType dataType() {
        return this.dtype;
    }

    public int numDimensions() {
        return this.shapeCopy.length;
    }

    public int numBytes() {
        return TensorImpl.numBytes(this.nativeHandle);
    }

    public int numElements() {
        return TensorImpl.computeNumElements(this.shapeCopy);
    }

    public int[] shape() {
        return this.shapeCopy;
    }

    public int[] shapeSignature() {
        return this.shapeSignatureCopy;
    }

    public int index() {
        return TensorImpl.index(this.nativeHandle);
    }

    public String name() {
        return TensorImpl.name(this.nativeHandle);
    }

    public Tensor.QuantizationParams quantizationParams() {
        return this.quantizationParamsCopy;
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.buffer().asReadOnlyBuffer().order(ByteOrder.nativeOrder());
    }

    void setTo(Object src) {
        if (src == null) {
            if (TensorImpl.hasDelegateBufferHandle(this.nativeHandle)) {
                return;
            }
            throw new IllegalArgumentException("Null inputs are allowed only if the Tensor is bound to a buffer handle.");
        }
        this.throwIfTypeIsIncompatible(src);
        this.throwIfSrcShapeIsIncompatible(src);
        if (TensorImpl.isBuffer(src)) {
            this.setTo((Buffer)src);
        } else if (this.dtype == DataType.STRING && this.shapeCopy.length == 0) {
            TensorImpl.writeScalar(this.nativeHandle, src);
        } else if (src.getClass().isArray()) {
            TensorImpl.writeMultiDimensionalArray(this.nativeHandle, src);
        } else {
            TensorImpl.writeScalar(this.nativeHandle, src);
        }
    }

    private void setTo(Buffer src) {
        if (src instanceof ByteBuffer) {
            ByteBuffer srcBuffer = (ByteBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                TensorImpl.writeDirectBuffer(this.nativeHandle, src);
            } else {
                this.buffer().put(srcBuffer);
            }
        } else if (src instanceof LongBuffer) {
            LongBuffer srcBuffer = (LongBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                TensorImpl.writeDirectBuffer(this.nativeHandle, src);
            } else {
                this.buffer().asLongBuffer().put(srcBuffer);
            }
        } else if (src instanceof FloatBuffer) {
            FloatBuffer srcBuffer = (FloatBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                TensorImpl.writeDirectBuffer(this.nativeHandle, src);
            } else {
                this.buffer().asFloatBuffer().put(srcBuffer);
            }
        } else if (src instanceof IntBuffer) {
            IntBuffer srcBuffer = (IntBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                TensorImpl.writeDirectBuffer(this.nativeHandle, src);
            } else {
                this.buffer().asIntBuffer().put(srcBuffer);
            }
        } else if (src instanceof ShortBuffer) {
            ShortBuffer srcBuffer = (ShortBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                TensorImpl.writeDirectBuffer(this.nativeHandle, src);
            } else {
                this.buffer().asShortBuffer().put(srcBuffer);
            }
        } else {
            throw new IllegalArgumentException("Unexpected input buffer type: " + src);
        }
    }

    void copyTo(Object dst) {
        if (dst == null) {
            if (TensorImpl.hasDelegateBufferHandle(this.nativeHandle)) {
                return;
            }
            throw new IllegalArgumentException("Null outputs are allowed only if the Tensor is bound to a buffer handle.");
        }
        this.throwIfTypeIsIncompatible(dst);
        this.throwIfDstShapeIsIncompatible(dst);
        if (TensorImpl.isBuffer(dst)) {
            this.copyTo((Buffer)dst);
        } else {
            TensorImpl.readMultiDimensionalArray(this.nativeHandle, dst);
        }
    }

    private void copyTo(Buffer dst) {
        if (dst instanceof ByteBuffer) {
            ((ByteBuffer)dst).put(this.buffer());
        } else if (dst instanceof FloatBuffer) {
            ((FloatBuffer)dst).put(this.buffer().asFloatBuffer());
        } else if (dst instanceof LongBuffer) {
            ((LongBuffer)dst).put(this.buffer().asLongBuffer());
        } else if (dst instanceof IntBuffer) {
            ((IntBuffer)dst).put(this.buffer().asIntBuffer());
        } else if (dst instanceof ShortBuffer) {
            ((ShortBuffer)dst).put(this.buffer().asShortBuffer());
        } else {
            throw new IllegalArgumentException("Unexpected output buffer type: " + dst);
        }
    }

    int[] getInputShapeIfDifferent(Object input) {
        if (input == null) {
            return null;
        }
        if (TensorImpl.isBuffer(input)) {
            return null;
        }
        this.throwIfTypeIsIncompatible(input);
        int[] inputShape = this.computeShapeOf(input);
        if (Arrays.equals(this.shapeCopy, inputShape)) {
            return null;
        }
        return inputShape;
    }

    void refreshShape() {
        this.shapeCopy = TensorImpl.shape(this.nativeHandle);
    }

    DataType dataTypeOf(@NonNull Object o) {
        Class<?> c = o.getClass();
        if (c.isArray()) {
            while (c.isArray()) {
                c = c.getComponentType();
            }
            if (Float.TYPE.equals(c)) {
                return DataType.FLOAT32;
            }
            if (Integer.TYPE.equals(c)) {
                return DataType.INT32;
            }
            if (Short.TYPE.equals(c)) {
                return DataType.INT16;
            }
            if (Byte.TYPE.equals(c)) {
                if (this.dtype == DataType.STRING) {
                    return DataType.STRING;
                }
                return DataType.UINT8;
            }
            if (Long.TYPE.equals(c)) {
                return DataType.INT64;
            }
            if (Boolean.TYPE.equals(c)) {
                return DataType.BOOL;
            }
            if (String.class.equals(c)) {
                return DataType.STRING;
            }
        } else {
            if (Float.class.equals(c) || o instanceof FloatBuffer) {
                return DataType.FLOAT32;
            }
            if (Integer.class.equals(c) || o instanceof IntBuffer) {
                return DataType.INT32;
            }
            if (Short.class.equals(c) || o instanceof ShortBuffer) {
                return DataType.INT16;
            }
            if (Byte.class.equals(c)) {
                return DataType.UINT8;
            }
            if (Long.class.equals(c) || o instanceof LongBuffer) {
                return DataType.INT64;
            }
            if (Boolean.class.equals(c)) {
                return DataType.BOOL;
            }
            if (String.class.equals(c)) {
                return DataType.STRING;
            }
        }
        throw new IllegalArgumentException("DataType error: cannot resolve DataType of " + o.getClass().getName());
    }

    private int[] computeShapeOf(Object o) {
        Class<?> c;
        int size = TensorImpl.computeNumDimensions(o);
        if (this.dtype == DataType.STRING && (c = o.getClass()).isArray()) {
            while (c.isArray()) {
                c = c.getComponentType();
            }
            if (Byte.TYPE.equals(c)) {
                --size;
            }
        }
        int[] dimensions = new int[size];
        TensorImpl.fillShape(o, 0, dimensions);
        return dimensions;
    }

    static int computeNumElements(int[] shape) {
        int n = 1;
        for (int j : shape) {
            n *= j;
        }
        return n;
    }

    static int computeNumDimensions(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return 0;
        }
        if (Array.getLength(o) == 0) {
            throw new IllegalArgumentException("Array lengths cannot be 0.");
        }
        return 1 + TensorImpl.computeNumDimensions(Array.get(o, 0));
    }

    static void fillShape(Object o, int dim, int[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int len = Array.getLength(o);
        if (shape[dim] == 0) {
            shape[dim] = len;
        } else if (shape[dim] != len) {
            throw new IllegalArgumentException(String.format("Mismatched lengths (%d and %d) in dimension %d", shape[dim], len, dim));
        }
        int nextDim = dim + 1;
        if (nextDim == shape.length) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            TensorImpl.fillShape(Array.get(o, i), nextDim, shape);
        }
    }

    private void throwIfTypeIsIncompatible(@NonNull Object o) {
        if (TensorImpl.isByteBuffer(o)) {
            return;
        }
        DataType oType = this.dataTypeOf(o);
        if (oType != this.dtype) {
            if (DataTypeUtils.toStringName(oType).equals(DataTypeUtils.toStringName(this.dtype))) {
                return;
            }
            throw new IllegalArgumentException(String.format("Cannot convert between a TensorFlowLite tensor with type %s and a Java object of type %s (which is compatible with the TensorFlowLite type %s).", this.dtype, o.getClass().getName(), oType));
        }
    }

    private void throwIfSrcShapeIsIncompatible(Object src) {
        if (TensorImpl.isBuffer(src)) {
            int srcBytes;
            Buffer srcBuffer = (Buffer)src;
            int bytes = this.numBytes();
            int n = srcBytes = TensorImpl.isByteBuffer(src) ? srcBuffer.capacity() : srcBuffer.capacity() * this.dtype.byteSize();
            if (bytes != srcBytes) {
                throw new IllegalArgumentException(String.format("Cannot copy to a TensorFlowLite tensor (%s) with %d bytes from a Java Buffer with %d bytes.", this.name(), bytes, srcBytes));
            }
            return;
        }
        int[] srcShape = this.computeShapeOf(src);
        if (!Arrays.equals(srcShape, this.shapeCopy)) {
            throw new IllegalArgumentException(String.format("Cannot copy to a TensorFlowLite tensor (%s) with shape %s from a Java object with shape %s.", this.name(), Arrays.toString(this.shapeCopy), Arrays.toString(srcShape)));
        }
    }

    private void throwIfDstShapeIsIncompatible(Object dst) {
        if (TensorImpl.isBuffer(dst)) {
            int dstBytes;
            Buffer dstBuffer = (Buffer)dst;
            int bytes = this.numBytes();
            int n = dstBytes = TensorImpl.isByteBuffer(dst) ? dstBuffer.capacity() : dstBuffer.capacity() * this.dtype.byteSize();
            if (bytes > dstBytes) {
                throw new IllegalArgumentException(String.format("Cannot copy from a TensorFlowLite tensor (%s) with %d bytes to a Java Buffer with %d bytes.", this.name(), bytes, dstBytes));
            }
            return;
        }
        int[] dstShape = this.computeShapeOf(dst);
        if (!Arrays.equals(dstShape, this.shapeCopy)) {
            throw new IllegalArgumentException(String.format("Cannot copy from a TensorFlowLite tensor (%s) with shape %s to a Java object with shape %s.", this.name(), Arrays.toString(this.shapeCopy), Arrays.toString(dstShape)));
        }
    }

    private static boolean isBuffer(Object o) {
        return o instanceof Buffer;
    }

    private static boolean isByteBuffer(Object o) {
        return o instanceof ByteBuffer;
    }

    private TensorImpl(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.dtype = DataTypeUtils.fromC(TensorImpl.dtype(nativeHandle));
        this.shapeCopy = TensorImpl.shape(nativeHandle);
        this.shapeSignatureCopy = TensorImpl.shapeSignature(nativeHandle);
        this.quantizationParamsCopy = new Tensor.QuantizationParams(TensorImpl.quantizationScale(nativeHandle), TensorImpl.quantizationZeroPoint(nativeHandle));
    }

    private ByteBuffer buffer() {
        return TensorImpl.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static native long create(long var0, int var2, int var3);

    private static native long createSignatureInputTensor(long var0, String var2);

    private static native long createSignatureOutputTensor(long var0, String var2);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native void writeDirectBuffer(long var0, Buffer var2);

    private static native int dtype(long var0);

    private static native int[] shape(long var0);

    private static native int[] shapeSignature(long var0);

    private static native int numBytes(long var0);

    private static native boolean hasDelegateBufferHandle(long var0);

    private static native void readMultiDimensionalArray(long var0, Object var2);

    private static native void writeMultiDimensionalArray(long var0, Object var2);

    private static native void writeScalar(long var0, Object var2);

    private static native int index(long var0);

    private static native String name(long var0);

    private static native float quantizationScale(long var0);

    private static native int quantizationZeroPoint(long var0);
}

