/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.gms.vision.detector;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.google.android.odml.image.MlImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.support.image.MlImageAdapter;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.gms.vision.core.BaseVisionTaskApi;
import org.tensorflow.lite.task.gms.vision.detector.Detection;
import org.tensorflow.lite.task.gms.vision.detector.zzb;
import org.tensorflow.lite.task.gms.vision.detector.zzc;
import org.tensorflow.lite.task.gms.vision.detector.zzd;
import org.tensorflow.lite.task.gms.vision.detector.zze;
import org.tensorflow.lite.task.gms.vision.detector.zzf;
import org.tensorflow.lite.task.gms.vision.detector.zzg;

public final class ObjectDetector
extends BaseVisionTaskApi {
    private static native long initJniWithByteBuffer(ByteBuffer var0, ObjectDetectorOptions var1, long var2);

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, ObjectDetectorOptions var5, long var6);

    /*
     * WARNING - void declaration
     */
    public List<Detection> detect(MlImage image) {
        void var1_1;
        return this.detect((MlImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Detection> detect(TensorImage image) {
        void var1_1;
        return this.detect((TensorImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Detection> detect(MlImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        image.getInternal().acquire();
        TensorImage tensorImage = MlImageAdapter.createTensorImageFrom((MlImage)var1_1);
        Object object = object.detect(tensorImage, (ImageProcessingOptions)var2_2);
        var1_1.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public List<Detection> detect(TensorImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        zze zze2 = new zze(this);
        return (List)this.run(zze2, (TensorImage)var1_1, (ImageProcessingOptions)var2_2);
    }

    private static native List<Detection> detectNative(long var0, long var2);

    public static ObjectDetector createFromBuffer(ByteBuffer modelBuffer) {
        return ObjectDetector.createFromBufferAndOptions(modelBuffer, ObjectDetectorOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ObjectDetector createFromBufferAndOptions(ByteBuffer modelBuffer, ObjectDetectorOptions options) {
        void var1_1;
        Object object;
        if (!modelBuffer.isDirect() && !(object instanceof MappedByteBuffer)) {
            object = new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
            throw object;
        }
        zzd zzd2 = new zzd((ByteBuffer)object, (ObjectDetectorOptions)var1_1);
        ObjectDetector objectDetector = new ObjectDetector(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzd2, (String)"task_vision_jni_gms"));
        return objectDetector;
    }

    public static ObjectDetector createFromFile(File modelFile) throws IOException {
        return ObjectDetector.createFromFileAndOptions(modelFile, ObjectDetectorOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ObjectDetector createFromFile(Context context, String modelPath) throws IOException {
        void var1_1;
        return ObjectDetector.createFromFileAndOptions(context, (String)var1_1, ObjectDetectorOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectDetector createFromFileAndOptions(File modelFile, ObjectDetectorOptions options) throws IOException {
        ObjectDetector objectDetector;
        File file = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);
        try {
            void var1_2;
            zzc zzc2 = new zzc((ParcelFileDescriptor)file, (ObjectDetectorOptions)var1_2);
            objectDetector = new ObjectDetector(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzc2, (String)"task_vision_jni_gms"));
            if (file == null) return objectDetector;
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            try {
                file.close();
            }
            catch (Throwable throwable2) {
                try {
                    Object object = new Class[]{Throwable.class};
                    object = Throwable.class.getDeclaredMethod("addSuppressed", (Class<?>)object);
                    Object[] objectArray = new Object[]{throwable2};
                    ((Method)object).invoke((Object)throwable, objectArray);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            throw throwable;
        }
        file.close();
        return objectDetector;
    }

    /*
     * WARNING - void declaration
     */
    public static ObjectDetector createFromFileAndOptions(Context context, String modelPath, ObjectDetectorOptions options) throws IOException {
        void var2_2;
        void var1_1;
        Context context2;
        zzb zzb2 = new zzb();
        ObjectDetector objectDetector = new ObjectDetector(TaskJniUtils.createHandleFromFdAndOptions((Context)context2, (TaskJniUtils.FdAndOptionsHandleProvider)zzb2, (String)"task_vision_jni_gms", (String)var1_1, (Object)var2_2));
        return objectDetector;
    }

    private ObjectDetector(long l) {
        super(l);
    }

    /*
     * WARNING - void declaration
     */
    protected void deinit(long nativeHandle) {
        void var1_1;
        this.deinitJni((long)var1_1);
    }

    private native void deinitJni(long var1);

    static /* bridge */ /* synthetic */ long zza(ByteBuffer byteBuffer, ObjectDetectorOptions objectDetectorOptions, long l) {
        return ObjectDetector.initJniWithByteBuffer(byteBuffer, objectDetectorOptions, l);
    }

    static /* bridge */ /* synthetic */ long zzb(int n, long l, long l2, ObjectDetectorOptions objectDetectorOptions, long l3) {
        return ObjectDetector.initJniWithModelFdAndOptions(n, l, l2, objectDetectorOptions, l3);
    }

    static /* bridge */ /* synthetic */ List zzc(ObjectDetector objectDetector, long l, ImageProcessingOptions imageProcessingOptions) {
        objectDetector.checkNotClosed();
        return ObjectDetector.detectNative(objectDetector.getNativeHandle(), l);
    }

    @UsedByReflection(value="object_detector_jni.cc")
    public static class ObjectDetectorOptions {
        private final BaseOptions zza;
        private final String zzb;
        private final int zzc;
        private final float zzd;
        private final boolean zze;
        private final List zzf;
        private final List zzg;
        private final int zzh;

        @UsedByReflection(value="object_detector_jni.cc")
        public float getScoreThreshold() {
            return this.zzd;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public int getMaxResults() {
            return this.zzc;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public int getNumThreads() {
            return this.zzh;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public String getDisplayNamesLocale() {
            return this.zzb;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public List<String> getLabelAllowList() {
            ArrayList<String> arrayList = new ArrayList<String>(this.zzf);
            return arrayList;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public List<String> getLabelDenyList() {
            ArrayList<String> arrayList = new ArrayList<String>(this.zzg);
            return arrayList;
        }

        public BaseOptions getBaseOptions() {
            return this.zza;
        }

        public static Builder builder() {
            Builder builder = new Builder(null);
            return builder;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public boolean getIsScoreThresholdSet() {
            return this.zze;
        }

        /* synthetic */ ObjectDetectorOptions(Builder builder, zzg zzg2) {
            this.zzb = builder.zzb;
            this.zzc = builder.zzc;
            this.zzd = builder.zzd;
            this.zze = builder.zze;
            this.zzf = builder.zzf;
            this.zzg = builder.zzg;
            this.zzh = builder.zzh;
            this.zza = builder.zza;
        }

        public static class Builder {
            private BaseOptions zza = BaseOptions.builder().build();
            private String zzb = "en";
            private int zzc = -1;
            private float zzd;
            private boolean zze = false;
            private List zzf;
            private List zzg;
            private int zzh;

            /*
             * WARNING - void declaration
             */
            public Builder setBaseOptions(BaseOptions baseOptions) {
                void var1_1;
                this.zza = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setDisplayNamesLocale(String displayNamesLocale) {
                void var1_1;
                this.zzb = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setLabelAllowList(List<String> labelAllowList) {
                void var1_1;
                ArrayList arrayList = new ArrayList(var1_1);
                this.zzf = Collections.unmodifiableList(arrayList);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setLabelDenyList(List<String> labelDenyList) {
                void var1_1;
                ArrayList arrayList = new ArrayList(var1_1);
                this.zzg = Collections.unmodifiableList(arrayList);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setMaxResults(int maxResults) {
                void var1_1;
                if (maxResults == 0) {
                    Object object = new IllegalArgumentException("maxResults cannot be 0.");
                    throw object;
                }
                ((Builder)object).zzc = var1_1;
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            public Builder setNumThreads(int numThreads) {
                void var1_1;
                this.zzh = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setScoreThreshold(float scoreThreshold) {
                void var1_1;
                this.zzd = var1_1;
                this.zze = true;
                return this;
            }

            public ObjectDetectorOptions build() {
                ObjectDetectorOptions objectDetectorOptions = new ObjectDetectorOptions(this, null);
                return objectDetectorOptions;
            }

            private Builder() {
                ArrayList arrayList;
                this.zzf = arrayList = new ArrayList();
                this.zzg = arrayList = new ArrayList();
                this.zzh = -1;
            }

            /* synthetic */ Builder(zzf arrayList) {
                this.zzf = arrayList = new ArrayList();
                this.zzg = arrayList = new ArrayList();
                this.zzh = -1;
            }
        }
    }
}

