/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.processor;

import androidx.annotation.Nullable;
import java.io.File;
import org.tensorflow.lite.task.processor.SearcherOptions;

final class AutoValue_SearcherOptions
extends SearcherOptions {
    private final boolean l2Normalize;
    private final boolean quantize;
    private final File indexFile;
    private final int maxResults;

    private AutoValue_SearcherOptions(boolean l2Normalize, boolean quantize, @Nullable File indexFile, int maxResults) {
        this.l2Normalize = l2Normalize;
        this.quantize = quantize;
        this.indexFile = indexFile;
        this.maxResults = maxResults;
    }

    @Override
    public boolean getL2Normalize() {
        return this.l2Normalize;
    }

    @Override
    public boolean getQuantize() {
        return this.quantize;
    }

    @Override
    @Nullable
    public File getIndexFile() {
        return this.indexFile;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    public String toString() {
        return "SearcherOptions{l2Normalize=" + this.l2Normalize + ", quantize=" + this.quantize + ", indexFile=" + this.indexFile + ", maxResults=" + this.maxResults + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SearcherOptions) {
            SearcherOptions that = (SearcherOptions)o;
            return this.l2Normalize == that.getL2Normalize() && this.quantize == that.getQuantize() && (this.indexFile == null ? that.getIndexFile() == null : this.indexFile.equals(that.getIndexFile())) && this.maxResults == that.getMaxResults();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.l2Normalize ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.quantize ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.indexFile == null ? 0 : this.indexFile.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxResults;
    }

    static final class Builder
    extends SearcherOptions.Builder {
        private Boolean l2Normalize;
        private Boolean quantize;
        private File indexFile;
        private Integer maxResults;

        Builder() {
        }

        @Override
        public SearcherOptions.Builder setL2Normalize(boolean l2Normalize) {
            this.l2Normalize = l2Normalize;
            return this;
        }

        @Override
        public SearcherOptions.Builder setQuantize(boolean quantize) {
            this.quantize = quantize;
            return this;
        }

        @Override
        public SearcherOptions.Builder setIndexFile(@Nullable File indexFile) {
            this.indexFile = indexFile;
            return this;
        }

        @Override
        public SearcherOptions.Builder setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public SearcherOptions build() {
            String missing = "";
            if (this.l2Normalize == null) {
                missing = missing + " l2Normalize";
            }
            if (this.quantize == null) {
                missing = missing + " quantize";
            }
            if (this.maxResults == null) {
                missing = missing + " maxResults";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SearcherOptions(this.l2Normalize, this.quantize, this.indexFile, this.maxResults);
        }
    }
}

