/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.processor;

import java.nio.ByteBuffer;
import org.tensorflow.lite.task.processor.NearestNeighbor;

final class AutoValue_NearestNeighbor
extends NearestNeighbor {
    private final ByteBuffer metadata;
    private final float distance;

    AutoValue_NearestNeighbor(ByteBuffer metadata, float distance) {
        if (metadata == null) {
            throw new NullPointerException("Null metadata");
        }
        this.metadata = metadata;
        this.distance = distance;
    }

    @Override
    public ByteBuffer getMetadata() {
        return this.metadata;
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    public String toString() {
        return "NearestNeighbor{metadata=" + this.metadata + ", distance=" + this.distance + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NearestNeighbor) {
            NearestNeighbor that = (NearestNeighbor)o;
            return this.metadata.equals(that.getMetadata()) && Float.floatToIntBits(this.distance) == Float.floatToIntBits(that.getDistance());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= Float.floatToIntBits(this.distance);
    }
}

