/*
 Copyright 2022 The TensorFlow Authors. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 =======================================================================
 */
module org.tensorflow.ndarray {
  requires jdk.unsupported; // required by raw buffer implementations using Unsafe

  exports org.tensorflow.ndarray;
  exports org.tensorflow.ndarray.buffer;
  exports org.tensorflow.ndarray.buffer.layout;
  exports org.tensorflow.ndarray.index;

  // Expose all implementions of our interfaces, so consumers can write custom
  // implementations easily by extending from them
  exports org.tensorflow.ndarray.impl.buffer;
  exports org.tensorflow.ndarray.impl.buffer.adapter;
  exports org.tensorflow.ndarray.impl.buffer.layout;
  exports org.tensorflow.ndarray.impl.buffer.misc;
  exports org.tensorflow.ndarray.impl.buffer.nio;
  exports org.tensorflow.ndarray.impl.buffer.raw;
  exports org.tensorflow.ndarray.impl.dense;
  exports org.tensorflow.ndarray.impl.dimension;
  exports org.tensorflow.ndarray.impl.sequence;
  exports org.tensorflow.ndarray.impl.sparse;
  exports org.tensorflow.ndarray.impl.sparse.slice;
}
