/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.webhook;

import io.javalin.Javalin;
import io.javalin.community.ssl.SslPlugin;
import io.javalin.plugin.Plugin;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.webhook.DefaultTelegramWebhookBot;
import org.telegram.telegrambots.webhook.TelegramWebhookBot;
import org.telegram.telegrambots.webhook.WebhookOptions;

public class TelegramBotsWebhookApplication
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramBotsWebhookApplication.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final WebhookOptions webhookOptions;
    private final ConcurrentHashMap<String, TelegramWebhookBot> registeredBots = new ConcurrentHashMap();
    private Javalin app;

    public TelegramBotsWebhookApplication() throws TelegramApiException {
        this(WebhookOptions.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelegramBotsWebhookApplication(WebhookOptions webhookOptions) throws TelegramApiException {
        webhookOptions.validate();
        this.webhookOptions = webhookOptions;
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            this.startServerInternal();
            this.isRunning.set(true);
        }
    }

    public void registerBot(String botPath, Function<Update, BotApiMethod<?>> updateHandler, Runnable setWebhook, Runnable deleteWebhook) throws TelegramApiException {
        this.registerBot(DefaultTelegramWebhookBot.builder().botPath(botPath).updateHandler(updateHandler).setWebhook(setWebhook).deleteWebhook(deleteWebhook).build());
    }

    public void unregisterBot(String botPath) throws TelegramApiException {
        if (this.isRunning()) {
            TelegramWebhookBot removedBot = this.registeredBots.remove(botPath);
            if (removedBot != null) {
                removedBot.runDeleteWebhook();
                this.stop();
                this.start();
            }
        } else {
            throw new TelegramApiException("Server is not running");
        }
    }

    public void registerBot(TelegramWebhookBot telegramWebhookBot) throws TelegramApiException {
        if (this.isRunning()) {
            if (this.registeredBots.put(telegramWebhookBot.getBotPath(), telegramWebhookBot) == null) {
                this.setPostHandler(telegramWebhookBot);
            } else {
                this.stop();
                this.start();
            }
        } else {
            throw new TelegramApiException("Server is not running");
        }
    }

    public void unregisterBot(TelegramWebhookBot telegramWebhookBot) throws TelegramApiException {
        this.unregisterBot(telegramWebhookBot.getBotPath());
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws TelegramApiException {
        if (this.isRunning.get()) {
            throw new TelegramApiException("Server already running");
        }
        AtomicBoolean atomicBoolean = this.isRunning;
        synchronized (atomicBoolean) {
            if (this.isRunning.get()) {
                throw new TelegramApiException("Server already running");
            }
            this.startServerInternal();
            this.isRunning.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws TelegramApiException {
        if (this.isRunning.get()) {
            AtomicBoolean atomicBoolean = this.isRunning;
            synchronized (atomicBoolean) {
                if (this.isRunning.get()) {
                    for (Map.Entry<String, TelegramWebhookBot> bot : this.registeredBots.entrySet()) {
                        bot.getValue().runDeleteWebhook();
                    }
                } else {
                    throw new TelegramApiException("Server is not running");
                }
                this.app.stop();
                this.app = null;
                this.isRunning.set(false);
            }
        } else {
            throw new TelegramApiException("Server is not running");
        }
    }

    private void startServerInternal() throws TelegramApiException {
        this.app = Javalin.create(javalinConfig -> {
            SslPlugin sslPlugin = new SslPlugin(conf -> {
                if (this.webhookOptions.getUseHttps().booleanValue()) {
                    conf.keystoreFromPath(this.webhookOptions.getKeyStorePath(), this.webhookOptions.getKeyStorePassword());
                    conf.insecure = false;
                    conf.secure = true;
                    conf.securePort = this.webhookOptions.getPort();
                    javalinConfig.bundledPlugins.enableSslRedirects();
                } else {
                    conf.insecure = true;
                    conf.secure = false;
                    conf.insecurePort = this.webhookOptions.getPort();
                }
            });
            javalinConfig.registerPlugin((Plugin)sslPlugin);
            javalinConfig.http.defaultContentType = "application/json";
            javalinConfig.requestLogger.http((ctx, executionTimeMs) -> {
                if (this.webhookOptions.getEnableRequestLogging().booleanValue()) {
                    log.info("Webhook {} request received from {}", (Object)ctx.method(), (Object)ctx.req().getRemoteAddr());
                }
            });
        }).events(events -> {
            events.serverStarted(() -> log.info("Webhook server started"));
            events.serverStopped(() -> log.info("Webhook server stopped"));
        }).start();
        for (Map.Entry<String, TelegramWebhookBot> bot : this.registeredBots.entrySet()) {
            this.setPostHandler(bot.getValue());
        }
    }

    private void setPostHandler(TelegramWebhookBot telegramWebhookBot) {
        this.app.post(telegramWebhookBot.getBotPath(), ctx -> {
            Update update = (Update)ctx.bodyStreamAsClass(Update.class);
            BotApiMethod<?> response = telegramWebhookBot.consumeUpdate(update);
            if (response != null) {
                response.validate();
                ctx.json(response);
            }
            ctx.status(200);
        });
        telegramWebhookBot.runSetWebhook();
    }

    @Override
    public void close() throws TelegramApiException {
        this.stop();
    }
}

