/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.longpolling.starter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.telegram.telegrambots.longpolling.BotSession;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.starter.AfterBotRegistration;
import org.telegram.telegrambots.longpolling.starter.SpringLongPollingBot;
import org.telegram.telegrambots.longpolling.util.DefaultGetUpdatesGenerator;
import org.telegram.telegrambots.meta.TelegramUrl;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class TelegramBotInitializer
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramBotInitializer.class);
    private final TelegramBotsLongPollingApplication telegramBotsApplication;
    private final List<SpringLongPollingBot> longPollingBots;
    private final TelegramUrl telegramUrl;

    public TelegramBotInitializer(@NonNull TelegramBotsLongPollingApplication telegramBotsApplication, @NonNull List<SpringLongPollingBot> longPollingBots) {
        this(telegramBotsApplication, longPollingBots, TelegramUrl.DEFAULT_URL);
        if (telegramBotsApplication == null) {
            throw new NullPointerException("telegramBotsApplication is marked non-null but is null");
        }
        if (longPollingBots == null) {
            throw new NullPointerException("longPollingBots is marked non-null but is null");
        }
    }

    public TelegramBotInitializer(@NonNull TelegramBotsLongPollingApplication telegramBotsApplication, @NonNull List<SpringLongPollingBot> longPollingBots, TelegramUrl telegramUrl) {
        if (telegramBotsApplication == null) {
            throw new NullPointerException("telegramBotsApplication is marked non-null but is null");
        }
        if (longPollingBots == null) {
            throw new NullPointerException("longPollingBots is marked non-null but is null");
        }
        this.telegramBotsApplication = telegramBotsApplication;
        this.longPollingBots = longPollingBots;
        this.telegramUrl = telegramUrl;
    }

    public void afterPropertiesSet() {
        try {
            for (SpringLongPollingBot longPollingBot : this.longPollingBots) {
                BotSession session = this.telegramBotsApplication.registerBot(longPollingBot.getBotToken(), () -> this.telegramUrl, (Function)new DefaultGetUpdatesGenerator(), longPollingBot.getUpdatesConsumer());
                this.handleAfterRegistrationHook(longPollingBot, session);
            }
        }
        catch (TelegramApiException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleAfterRegistrationHook(Object bot, BotSession botSession) {
        Stream.of(bot.getClass().getMethods()).filter(method -> method.getAnnotation(AfterBotRegistration.class) != null).forEach(method -> this.handleAnnotatedMethod(bot, (Method)method, botSession));
    }

    private void handleAnnotatedMethod(Object bot, Method method, BotSession session) {
        try {
            if (method.getParameterCount() > 1) {
                log.warn(String.format("Method %s of Type %s has too many parameters", method.getName(), method.getDeclaringClass().getCanonicalName()));
                return;
            }
            if (method.getParameterCount() == 0) {
                method.invoke(bot, new Object[0]);
                return;
            }
            if (method.getParameterTypes()[0].equals(BotSession.class)) {
                method.invoke(bot, session);
                return;
            }
            log.warn(String.format("Method %s of Type %s has invalid parameter type", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(String.format("Couldn't invoke Method %s of Type %s", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
    }
}

