/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.stories.input;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.stories.input.InputStoryContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class InputStoryContentVideo
extends InputStoryContent {
    private static final String TYPE = "video";
    private static final String VIDEO_FIELD = "video";
    private static final String DURATION_FIELD = "duration";
    private static final String COVER_FRAME_TIMESTAMP_FIELD = "cover_frame_timestamp";
    private static final String IS_ANIMATION_FIELD = "is_animation";
    @JsonProperty(value="video")
    @NonNull
    private String video;
    @JsonProperty(value="duration")
    private Float duration;
    @JsonProperty(value="cover_frame_timestamp")
    private Float coverFrameTimestamp;
    @JsonProperty(value="is_animation")
    private Boolean isAnimation;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.video.isEmpty()) {
            throw new TelegramApiValidationException("Video can't be empty", this);
        }
        if (this.duration != null && (this.duration.floatValue() < 0.0f || this.duration.floatValue() > 60.0f)) {
            throw new TelegramApiValidationException("Duration must be between 0 and 60 seconds", this);
        }
    }

    @Override
    public String getType() {
        return "video";
    }

    @Generated
    protected InputStoryContentVideo(InputStoryContentVideoBuilder<?, ?> b) {
        super(b);
        this.video = b.video;
        if (this.video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.duration = b.duration;
        this.coverFrameTimestamp = b.coverFrameTimestamp;
        this.isAnimation = b.isAnimation;
    }

    @Generated
    public static InputStoryContentVideoBuilder<?, ?> builder() {
        return new InputStoryContentVideoBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputStoryContentVideo)) {
            return false;
        }
        InputStoryContentVideo other = (InputStoryContentVideo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$duration = this.getDuration();
        Float other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Float this$coverFrameTimestamp = this.getCoverFrameTimestamp();
        Float other$coverFrameTimestamp = other.getCoverFrameTimestamp();
        if (this$coverFrameTimestamp == null ? other$coverFrameTimestamp != null : !((Object)this$coverFrameTimestamp).equals(other$coverFrameTimestamp)) {
            return false;
        }
        Boolean this$isAnimation = this.getIsAnimation();
        Boolean other$isAnimation = other.getIsAnimation();
        if (this$isAnimation == null ? other$isAnimation != null : !((Object)this$isAnimation).equals(other$isAnimation)) {
            return false;
        }
        String this$video = this.getVideo();
        String other$video = other.getVideo();
        return !(this$video == null ? other$video != null : !this$video.equals(other$video));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputStoryContentVideo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Float $coverFrameTimestamp = this.getCoverFrameTimestamp();
        result = result * 59 + ($coverFrameTimestamp == null ? 43 : ((Object)$coverFrameTimestamp).hashCode());
        Boolean $isAnimation = this.getIsAnimation();
        result = result * 59 + ($isAnimation == null ? 43 : ((Object)$isAnimation).hashCode());
        String $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : $video.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getVideo() {
        return this.video;
    }

    @Generated
    public Float getDuration() {
        return this.duration;
    }

    @Generated
    public Float getCoverFrameTimestamp() {
        return this.coverFrameTimestamp;
    }

    @Generated
    public Boolean getIsAnimation() {
        return this.isAnimation;
    }

    @JsonProperty(value="video")
    @Generated
    public void setVideo(@NonNull String video) {
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.video = video;
    }

    @JsonProperty(value="duration")
    @Generated
    public void setDuration(Float duration) {
        this.duration = duration;
    }

    @JsonProperty(value="cover_frame_timestamp")
    @Generated
    public void setCoverFrameTimestamp(Float coverFrameTimestamp) {
        this.coverFrameTimestamp = coverFrameTimestamp;
    }

    @JsonProperty(value="is_animation")
    @Generated
    public void setIsAnimation(Boolean isAnimation) {
        this.isAnimation = isAnimation;
    }

    @Override
    @Generated
    public String toString() {
        return "InputStoryContentVideo(video=" + this.getVideo() + ", duration=" + this.getDuration() + ", coverFrameTimestamp=" + this.getCoverFrameTimestamp() + ", isAnimation=" + this.getIsAnimation() + ")";
    }

    @Generated
    public InputStoryContentVideo() {
    }

    @Generated
    public InputStoryContentVideo(@NonNull String video) {
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.video = video;
    }

    @Generated
    public InputStoryContentVideo(@NonNull String video, Float duration, Float coverFrameTimestamp, Boolean isAnimation) {
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.video = video;
        this.duration = duration;
        this.coverFrameTimestamp = coverFrameTimestamp;
        this.isAnimation = isAnimation;
    }

    @Generated
    public static abstract class InputStoryContentVideoBuilder<C extends InputStoryContentVideo, B extends InputStoryContentVideoBuilder<C, B>>
    extends InputStoryContent.InputStoryContentBuilder<C, B> {
        @Generated
        private String video;
        @Generated
        private Float duration;
        @Generated
        private Float coverFrameTimestamp;
        @Generated
        private Boolean isAnimation;

        @JsonProperty(value="video")
        @Generated
        public B video(@NonNull String video) {
            if (video == null) {
                throw new NullPointerException("video is marked non-null but is null");
            }
            this.video = video;
            return (B)this.self();
        }

        @JsonProperty(value="duration")
        @Generated
        public B duration(Float duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @JsonProperty(value="cover_frame_timestamp")
        @Generated
        public B coverFrameTimestamp(Float coverFrameTimestamp) {
            this.coverFrameTimestamp = coverFrameTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="is_animation")
        @Generated
        public B isAnimation(Boolean isAnimation) {
            this.isAnimation = isAnimation;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InputStoryContentVideo.InputStoryContentVideoBuilder(super=" + super.toString() + ", video=" + this.video + ", duration=" + this.duration + ", coverFrameTimestamp=" + this.coverFrameTimestamp + ", isAnimation=" + this.isAnimation + ")";
        }
    }

    @Generated
    private static final class InputStoryContentVideoBuilderImpl
    extends InputStoryContentVideoBuilder<InputStoryContentVideo, InputStoryContentVideoBuilderImpl> {
        @Generated
        private InputStoryContentVideoBuilderImpl() {
        }

        @Override
        @Generated
        protected InputStoryContentVideoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputStoryContentVideo build() {
            return new InputStoryContentVideo(this);
        }
    }
}

