/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.verification;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=VerifyUserBuilderImpl.class)
public class VerifyUser
extends BotApiMethodBoolean {
    public static final String PATH = "verifyUser";
    private static final String USER_ID_FIELD = "user_id";
    private static final String CUSTOM_DESCRIPTION_FIELD = "custom_description";
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="custom_description")
    private String customDescription;

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredUserId(this.userId, this);
        if (this.customDescription != null && (this.customDescription.length() > 70 || this.customDescription.isEmpty())) {
            throw new TelegramApiValidationException("Custom description must be between 0 and 70 characters long", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Generated
    protected VerifyUser(VerifyUserBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.customDescription = b.customDescription;
    }

    @Generated
    public static VerifyUserBuilder<?, ?> builder() {
        return new VerifyUserBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyUser)) {
            return false;
        }
        VerifyUser other = (VerifyUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$customDescription = this.getCustomDescription();
        String other$customDescription = other.getCustomDescription();
        return !(this$customDescription == null ? other$customDescription != null : !this$customDescription.equals(other$customDescription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerifyUser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $customDescription = this.getCustomDescription();
        result = result * 59 + ($customDescription == null ? 43 : $customDescription.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getCustomDescription() {
        return this.customDescription;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="custom_description")
    @Generated
    public void setCustomDescription(String customDescription) {
        this.customDescription = customDescription;
    }

    @Generated
    public String toString() {
        return "VerifyUser(userId=" + this.getUserId() + ", customDescription=" + this.getCustomDescription() + ")";
    }

    @Generated
    public VerifyUser(@NonNull Long userId, String customDescription) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
        this.customDescription = customDescription;
    }

    @Generated
    public VerifyUser(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public static abstract class VerifyUserBuilder<C extends VerifyUser, B extends VerifyUserBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private Long userId;
        @Generated
        private String customDescription;

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="custom_description")
        @Generated
        public B customDescription(String customDescription) {
            this.customDescription = customDescription;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "VerifyUser.VerifyUserBuilder(super=" + super.toString() + ", userId=" + this.userId + ", customDescription=" + this.customDescription + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class VerifyUserBuilderImpl
    extends VerifyUserBuilder<VerifyUser, VerifyUserBuilderImpl> {
        @Generated
        private VerifyUserBuilderImpl() {
        }

        @Override
        @Generated
        protected VerifyUserBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VerifyUser build() {
            return new VerifyUser(this);
        }
    }
}

