/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.verification;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=VerifyChatBuilderImpl.class)
public class VerifyChat
extends BotApiMethodBoolean {
    public static final String PATH = "verifyChat";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String CUSTOM_DESCRIPTION_FIELD = "custom_description";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="custom_description")
    private String customDescription;

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.customDescription != null && (this.customDescription.length() > 70 || this.customDescription.isEmpty())) {
            throw new TelegramApiValidationException("Custom description must be between 0 and 70 characters long", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Generated
    protected VerifyChat(VerifyChatBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.customDescription = b.customDescription;
    }

    @Generated
    public static VerifyChatBuilder<?, ?> builder() {
        return new VerifyChatBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifyChat)) {
            return false;
        }
        VerifyChat other = (VerifyChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$customDescription = this.getCustomDescription();
        String other$customDescription = other.getCustomDescription();
        return !(this$customDescription == null ? other$customDescription != null : !this$customDescription.equals(other$customDescription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VerifyChat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $customDescription = this.getCustomDescription();
        result = result * 59 + ($customDescription == null ? 43 : $customDescription.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public String getCustomDescription() {
        return this.customDescription;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="custom_description")
    @Generated
    public void setCustomDescription(String customDescription) {
        this.customDescription = customDescription;
    }

    @Generated
    public String toString() {
        return "VerifyChat(chatId=" + this.getChatId() + ", customDescription=" + this.getCustomDescription() + ")";
    }

    @Generated
    public VerifyChat(@NonNull String chatId, String customDescription) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.customDescription = customDescription;
    }

    @Generated
    public VerifyChat(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public static abstract class VerifyChatBuilder<C extends VerifyChat, B extends VerifyChatBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private String customDescription;

        public VerifyChatBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="custom_description")
        @Generated
        public B customDescription(String customDescription) {
            this.customDescription = customDescription;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "VerifyChat.VerifyChatBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", customDescription=" + this.customDescription + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class VerifyChatBuilderImpl
    extends VerifyChatBuilder<VerifyChat, VerifyChatBuilderImpl> {
        @Generated
        private VerifyChatBuilderImpl() {
        }

        @Override
        @Generated
        protected VerifyChatBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VerifyChat build() {
            return new VerifyChat(this);
        }
    }
}

