/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SetStickerSetThumbnailBuilderImpl.class)
public class SetStickerSetThumbnail
extends BotApiMethodBoolean {
    public static final String PATH = "setStickerSetThumbnail";
    public static final String NAME_FIELD = "name";
    public static final String USER_ID_FIELD = "user_id";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String FORMAT_FIELD = "format";
    @NonNull
    private String name;
    @NonNull
    private Long userId;
    @NonNull
    private String format;
    private InputFile thumbnail;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be null", this);
        }
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be null", this);
        }
        if (!Arrays.asList("static", "animated", "video").contains(this.format)) {
            throw new TelegramApiValidationException("Format must be 'static', 'animated', 'video'", this);
        }
        if (this.thumbnail != null) {
            this.thumbnail.validate();
        }
    }

    @Generated
    protected SetStickerSetThumbnail(SetStickerSetThumbnailBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.format = b.format;
        if (this.format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.thumbnail = b.thumbnail;
    }

    @Generated
    public static SetStickerSetThumbnailBuilder<?, ?> builder() {
        return new SetStickerSetThumbnailBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetStickerSetThumbnail)) {
            return false;
        }
        SetStickerSetThumbnail other = (SetStickerSetThumbnail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetStickerSetThumbnail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public void setFormat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    @Generated
    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Generated
    public String toString() {
        return "SetStickerSetThumbnail(name=" + this.getName() + ", userId=" + this.getUserId() + ", format=" + this.getFormat() + ", thumbnail=" + this.getThumbnail() + ")";
    }

    @Generated
    public SetStickerSetThumbnail(@NonNull String name, @NonNull Long userId, @NonNull String format) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.name = name;
        this.userId = userId;
        this.format = format;
    }

    @Generated
    public SetStickerSetThumbnail(@NonNull String name, @NonNull Long userId, @NonNull String format, InputFile thumbnail) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.name = name;
        this.userId = userId;
        this.format = format;
        this.thumbnail = thumbnail;
    }

    @Generated
    public static abstract class SetStickerSetThumbnailBuilder<C extends SetStickerSetThumbnail, B extends SetStickerSetThumbnailBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String name;
        @Generated
        private Long userId;
        @Generated
        private String format;
        @Generated
        private InputFile thumbnail;

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B format(@NonNull String format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return (B)this.self();
        }

        @Generated
        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SetStickerSetThumbnail.SetStickerSetThumbnailBuilder(super=" + super.toString() + ", name=" + this.name + ", userId=" + this.userId + ", format=" + this.format + ", thumbnail=" + this.thumbnail + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SetStickerSetThumbnailBuilderImpl
    extends SetStickerSetThumbnailBuilder<SetStickerSetThumbnail, SetStickerSetThumbnailBuilderImpl> {
        @Generated
        private SetStickerSetThumbnailBuilderImpl() {
        }

        @Override
        @Generated
        protected SetStickerSetThumbnailBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SetStickerSetThumbnail build() {
            return new SetStickerSetThumbnail(this);
        }
    }
}

