/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=EditChatInviteLinkBuilderImpl.class)
public class EditChatInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "editChatInviteLink";
    private static final String CHATID_FIELD = "chat_id";
    private static final String INVITELINK_FIELD = "invite_link";
    private static final String EXPIREDATE_FIELD = "expire_date";
    private static final String MEMBERLIMIT_FIELD = "member_limit";
    private static final String NAME_FIELD = "name";
    private static final String CREATESJOINREQUEST_FIELD = "creates_join_request";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="invite_link")
    @NonNull
    private String inviteLink;
    @JsonProperty(value="expire_date")
    private Integer expireDate;
    @JsonProperty(value="member_limit")
    private Integer memberLimit;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="creates_join_request")
    private Boolean createsJoinRequest;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, ChatInviteLink.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (StringUtils.isEmpty((CharSequence)this.chatId)) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (StringUtils.isEmpty((CharSequence)this.inviteLink)) {
            throw new TelegramApiValidationException("InviteLink can't be empty", this);
        }
        if (this.name != null && this.name.length() > 32) {
            throw new TelegramApiValidationException("Name must be between 0 and 32 characters", this);
        }
        if (this.createsJoinRequest != null && this.memberLimit != null) {
            throw new TelegramApiValidationException("MemberLimit can not be used with CreatesJoinRequest field", this);
        }
        if (this.memberLimit != null && (this.memberLimit < 1 || this.memberLimit > 99999)) {
            throw new TelegramApiValidationException("MemberLimit must be between 1 and 99999", this);
        }
    }

    @Generated
    protected EditChatInviteLink(EditChatInviteLinkBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.inviteLink = b.inviteLink;
        if (this.inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.expireDate = b.expireDate;
        this.memberLimit = b.memberLimit;
        this.name = b.name;
        this.createsJoinRequest = b.createsJoinRequest;
    }

    @Generated
    public static EditChatInviteLinkBuilder<?, ?> builder() {
        return new EditChatInviteLinkBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditChatInviteLink)) {
            return false;
        }
        EditChatInviteLink other = (EditChatInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$expireDate = this.getExpireDate();
        Integer other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        Integer this$memberLimit = this.getMemberLimit();
        Integer other$memberLimit = other.getMemberLimit();
        if (this$memberLimit == null ? other$memberLimit != null : !((Object)this$memberLimit).equals(other$memberLimit)) {
            return false;
        }
        Boolean this$createsJoinRequest = this.getCreatesJoinRequest();
        Boolean other$createsJoinRequest = other.getCreatesJoinRequest();
        if (this$createsJoinRequest == null ? other$createsJoinRequest != null : !((Object)this$createsJoinRequest).equals(other$createsJoinRequest)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inviteLink = this.getInviteLink();
        String other$inviteLink = other.getInviteLink();
        if (this$inviteLink == null ? other$inviteLink != null : !this$inviteLink.equals(other$inviteLink)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditChatInviteLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        Integer $memberLimit = this.getMemberLimit();
        result = result * 59 + ($memberLimit == null ? 43 : ((Object)$memberLimit).hashCode());
        Boolean $createsJoinRequest = this.getCreatesJoinRequest();
        result = result * 59 + ($createsJoinRequest == null ? 43 : ((Object)$createsJoinRequest).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inviteLink = this.getInviteLink();
        result = result * 59 + ($inviteLink == null ? 43 : $inviteLink.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public String getInviteLink() {
        return this.inviteLink;
    }

    @Generated
    public Integer getExpireDate() {
        return this.expireDate;
    }

    @Generated
    public Integer getMemberLimit() {
        return this.memberLimit;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getCreatesJoinRequest() {
        return this.createsJoinRequest;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="invite_link")
    @Generated
    public void setInviteLink(@NonNull String inviteLink) {
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.inviteLink = inviteLink;
    }

    @JsonProperty(value="expire_date")
    @Generated
    public void setExpireDate(Integer expireDate) {
        this.expireDate = expireDate;
    }

    @JsonProperty(value="member_limit")
    @Generated
    public void setMemberLimit(Integer memberLimit) {
        this.memberLimit = memberLimit;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="creates_join_request")
    @Generated
    public void setCreatesJoinRequest(Boolean createsJoinRequest) {
        this.createsJoinRequest = createsJoinRequest;
    }

    @Generated
    public String toString() {
        return "EditChatInviteLink(chatId=" + this.getChatId() + ", inviteLink=" + this.getInviteLink() + ", expireDate=" + this.getExpireDate() + ", memberLimit=" + this.getMemberLimit() + ", name=" + this.getName() + ", createsJoinRequest=" + this.getCreatesJoinRequest() + ")";
    }

    @Generated
    public EditChatInviteLink(@NonNull String chatId, @NonNull String inviteLink, Integer expireDate, Integer memberLimit, String name, Boolean createsJoinRequest) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
        this.expireDate = expireDate;
        this.memberLimit = memberLimit;
        this.name = name;
        this.createsJoinRequest = createsJoinRequest;
    }

    @Generated
    public EditChatInviteLink(@NonNull String chatId, @NonNull String inviteLink) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
    }

    public static abstract class EditChatInviteLinkBuilder<C extends EditChatInviteLink, B extends EditChatInviteLinkBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ChatInviteLink, C, B> {
        @Generated
        private String chatId;
        @Generated
        private String inviteLink;
        @Generated
        private Integer expireDate;
        @Generated
        private Integer memberLimit;
        @Generated
        private String name;
        @Generated
        private Boolean createsJoinRequest;

        public EditChatInviteLinkBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="invite_link")
        @Generated
        public B inviteLink(@NonNull String inviteLink) {
            if (inviteLink == null) {
                throw new NullPointerException("inviteLink is marked non-null but is null");
            }
            this.inviteLink = inviteLink;
            return (B)this.self();
        }

        @JsonProperty(value="expire_date")
        @Generated
        public B expireDate(Integer expireDate) {
            this.expireDate = expireDate;
            return (B)this.self();
        }

        @JsonProperty(value="member_limit")
        @Generated
        public B memberLimit(Integer memberLimit) {
            this.memberLimit = memberLimit;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @JsonProperty(value="creates_join_request")
        @Generated
        public B createsJoinRequest(Boolean createsJoinRequest) {
            this.createsJoinRequest = createsJoinRequest;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EditChatInviteLink.EditChatInviteLinkBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", inviteLink=" + this.inviteLink + ", expireDate=" + this.expireDate + ", memberLimit=" + this.memberLimit + ", name=" + this.name + ", createsJoinRequest=" + this.createsJoinRequest + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EditChatInviteLinkBuilderImpl
    extends EditChatInviteLinkBuilder<EditChatInviteLink, EditChatInviteLinkBuilderImpl> {
        @Generated
        private EditChatInviteLinkBuilderImpl() {
        }

        @Override
        @Generated
        protected EditChatInviteLinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EditChatInviteLink build() {
            return new EditChatInviteLink(this);
        }
    }
}

