/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=BanChatSenderChatBuilderImpl.class)
public class BanChatSenderChat
extends BotApiMethodBoolean {
    public static final String PATH = "banChatSenderChat";
    private static final String CHATID_FIELD = "chat_id";
    private static final String SENDER_CHAT_ID_FIELD = "sender_chat_id";
    private static final String UNTILDATE_FIELD = "until_date";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="sender_chat_id")
    @NonNull
    private Long senderChatId;
    @JsonProperty(value="until_date")
    private Integer untilDate;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.senderChatId == 0L) {
            throw new TelegramApiValidationException("SenderChatId can't be null or 0", this);
        }
    }

    @Generated
    protected BanChatSenderChat(BanChatSenderChatBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.senderChatId = b.senderChatId;
        if (this.senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.untilDate = b.untilDate;
    }

    @Generated
    public static BanChatSenderChatBuilder<?, ?> builder() {
        return new BanChatSenderChatBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanChatSenderChat)) {
            return false;
        }
        BanChatSenderChat other = (BanChatSenderChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$senderChatId = this.getSenderChatId();
        Long other$senderChatId = other.getSenderChatId();
        if (this$senderChatId == null ? other$senderChatId != null : !((Object)this$senderChatId).equals(other$senderChatId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BanChatSenderChat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $senderChatId = this.getSenderChatId();
        result = result * 59 + ($senderChatId == null ? 43 : ((Object)$senderChatId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Long getSenderChatId() {
        return this.senderChatId;
    }

    @Generated
    public Integer getUntilDate() {
        return this.untilDate;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="sender_chat_id")
    @Generated
    public void setSenderChatId(@NonNull Long senderChatId) {
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.senderChatId = senderChatId;
    }

    @JsonProperty(value="until_date")
    @Generated
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    @Generated
    public String toString() {
        return "BanChatSenderChat(chatId=" + this.getChatId() + ", senderChatId=" + this.getSenderChatId() + ", untilDate=" + this.getUntilDate() + ")";
    }

    @Generated
    public BanChatSenderChat(@NonNull String chatId, @NonNull Long senderChatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.senderChatId = senderChatId;
    }

    @Generated
    public BanChatSenderChat(@NonNull String chatId, @NonNull Long senderChatId, Integer untilDate) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.senderChatId = senderChatId;
        this.untilDate = untilDate;
    }

    public static abstract class BanChatSenderChatBuilder<C extends BanChatSenderChat, B extends BanChatSenderChatBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Long senderChatId;
        @Generated
        private Integer untilDate;

        public BanChatSenderChatBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="sender_chat_id")
        @Generated
        public B senderChatId(@NonNull Long senderChatId) {
            if (senderChatId == null) {
                throw new NullPointerException("senderChatId is marked non-null but is null");
            }
            this.senderChatId = senderChatId;
            return (B)this.self();
        }

        @JsonProperty(value="until_date")
        @Generated
        public B untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BanChatSenderChat.BanChatSenderChatBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", senderChatId=" + this.senderChatId + ", untilDate=" + this.untilDate + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class BanChatSenderChatBuilderImpl
    extends BanChatSenderChatBuilder<BanChatSenderChat, BanChatSenderChatBuilderImpl> {
        @Generated
        private BanChatSenderChatBuilderImpl() {
        }

        @Override
        @Generated
        protected BanChatSenderChatBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BanChatSenderChat build() {
            return new BanChatSenderChat(this);
        }
    }
}

