/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media.paid;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputPaidMediaVideoBuilderImpl.class)
public class InputPaidMediaVideo
extends InputPaidMedia {
    private static final String TYPE = "photo";
    private static final String WIDTH_FIELD = "width";
    private static final String HEIGHT_FIELD = "height";
    private static final String DURATION_FIELD = "duration";
    private static final String SUPPORTS_STREAMING_FIELD = "supports_streaming";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="supports_streaming")
    private Boolean supportsStreaming;
    @JsonProperty(value="thumbnail")
    private InputFile thumbnail;

    public InputPaidMediaVideo(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputPaidMediaVideo(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputPaidMediaVideo(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputPaidMediaVideo(@NonNull String media, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Integer width, Integer height, Integer duration, Boolean supportsStreaming, InputFile thumbnail) {
        super(media, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.supportsStreaming = supportsStreaming;
        this.thumbnail = thumbnail;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    protected InputPaidMediaVideo(InputPaidMediaVideoBuilder<?, ?> b) {
        super(b);
        this.width = b.width;
        this.height = b.height;
        this.duration = b.duration;
        this.supportsStreaming = b.supportsStreaming;
        this.thumbnail = b.thumbnail;
    }

    public static InputPaidMediaVideoBuilder<?, ?> builder() {
        return new InputPaidMediaVideoBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputPaidMediaVideo)) {
            return false;
        }
        InputPaidMediaVideo other = (InputPaidMediaVideo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$supportsStreaming = this.getSupportsStreaming();
        Boolean other$supportsStreaming = other.getSupportsStreaming();
        if (this$supportsStreaming == null ? other$supportsStreaming != null : !((Object)this$supportsStreaming).equals(other$supportsStreaming)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputPaidMediaVideo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $supportsStreaming = this.getSupportsStreaming();
        result = result * 59 + ($supportsStreaming == null ? 43 : ((Object)$supportsStreaming).hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Boolean getSupportsStreaming() {
        return this.supportsStreaming;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @JsonProperty(value="width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonProperty(value="height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="supports_streaming")
    public void setSupportsStreaming(Boolean supportsStreaming) {
        this.supportsStreaming = supportsStreaming;
    }

    @JsonProperty(value="thumbnail")
    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public String toString() {
        return "InputPaidMediaVideo(width=" + this.getWidth() + ", height=" + this.getHeight() + ", duration=" + this.getDuration() + ", supportsStreaming=" + this.getSupportsStreaming() + ", thumbnail=" + this.getThumbnail() + ")";
    }

    public InputPaidMediaVideo(Integer width, Integer height, Integer duration, Boolean supportsStreaming, InputFile thumbnail) {
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.supportsStreaming = supportsStreaming;
        this.thumbnail = thumbnail;
    }

    public static abstract class InputPaidMediaVideoBuilder<C extends InputPaidMediaVideo, B extends InputPaidMediaVideoBuilder<C, B>>
    extends InputPaidMedia.InputPaidMediaBuilder<C, B> {
        private Integer width;
        private Integer height;
        private Integer duration;
        private Boolean supportsStreaming;
        private InputFile thumbnail;

        @JsonProperty(value="width")
        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        @JsonProperty(value="height")
        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        @JsonProperty(value="duration")
        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @JsonProperty(value="supports_streaming")
        public B supportsStreaming(Boolean supportsStreaming) {
            this.supportsStreaming = supportsStreaming;
            return (B)this.self();
        }

        @JsonProperty(value="thumbnail")
        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InputPaidMediaVideo.InputPaidMediaVideoBuilder(super=" + super.toString() + ", width=" + this.width + ", height=" + this.height + ", duration=" + this.duration + ", supportsStreaming=" + this.supportsStreaming + ", thumbnail=" + this.thumbnail + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputPaidMediaVideoBuilderImpl
    extends InputPaidMediaVideoBuilder<InputPaidMediaVideo, InputPaidMediaVideoBuilderImpl> {
        private InputPaidMediaVideoBuilderImpl() {
        }

        @Override
        protected InputPaidMediaVideoBuilderImpl self() {
            return this;
        }

        @Override
        public InputPaidMediaVideo build() {
            return new InputPaidMediaVideo(this);
        }
    }
}

