/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMedia;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SendPaidMediaBuilderImpl.class)
public class SendPaidMedia
extends PartialBotApiMethod<ArrayList<Message>> {
    public static final String PATH = "sendPaidMedia";
    public static final String CHAT_ID_FIELD = "chat_id";
    public static final String STAR_COUNT_FIELD = "star_count";
    public static final String MEDIA_FIELD = "media";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSE_MODE_FIELD = "parse_mode";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    public static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    public static final String PROTECT_CONTENT_FIELD = "protect_content";
    public static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    public static final String REPLY_MARKUP_FIELD = "reply_markup";
    @NonNull
    private String chatId;
    @NonNull
    private Integer starCount;
    @NonNull
    private List<InputPaidMedia> media;
    private String caption;
    private String parseMode;
    private List<MessageEntity> captionEntities;
    private Boolean showCaptionAboveMedia;
    private Boolean disableNotification;
    private Boolean protectContent;
    private ReplyParameters replyParameters;
    private ReplyKeyboard replyMarkup;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public ArrayList<Message> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.media.isEmpty()) {
            throw new TelegramApiValidationException("Media parameter can't be empty", this);
        }
        if (this.media.size() < 2 || this.media.size() > 10) {
            throw new TelegramApiValidationException("Number of media should be between 2 and 10", this);
        }
        for (InputPaidMedia inputMedia : this.media) {
            if (inputMedia == null) {
                throw new TelegramApiValidationException("Media parameter can not be empty", this);
            }
            inputMedia.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    protected SendPaidMedia(SendPaidMediaBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.starCount = b.starCount;
        if (this.starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.media = b.media;
        if (this.media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = b.captionEntities;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
        this.disableNotification = b.disableNotification;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.replyMarkup = b.replyMarkup;
    }

    public static SendPaidMediaBuilder<?, ?> builder() {
        return new SendPaidMediaBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPaidMedia)) {
            return false;
        }
        SendPaidMedia other = (SendPaidMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$starCount = this.getStarCount();
        Integer other$starCount = other.getStarCount();
        if (this$starCount == null ? other$starCount != null : !((Object)this$starCount).equals(other$starCount)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<InputPaidMedia> this$media = this.getMedia();
        List<InputPaidMedia> other$media = other.getMedia();
        if (this$media == null ? other$media != null : !((Object)this$media).equals(other$media)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendPaidMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $starCount = this.getStarCount();
        result = result * 59 + ($starCount == null ? 43 : ((Object)$starCount).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<InputPaidMedia> $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : ((Object)$media).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getStarCount() {
        return this.starCount;
    }

    @NonNull
    public List<InputPaidMedia> getMedia() {
        return this.media;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setStarCount(@NonNull Integer starCount) {
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.starCount = starCount;
    }

    public void setMedia(@NonNull List<InputPaidMedia> media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public String toString() {
        return "SendPaidMedia(chatId=" + this.getChatId() + ", starCount=" + this.getStarCount() + ", media=" + this.getMedia() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    public SendPaidMedia(@NonNull String chatId, @NonNull Integer starCount, @NonNull List<InputPaidMedia> media) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.starCount = starCount;
        this.media = media;
    }

    public SendPaidMedia(@NonNull String chatId, @NonNull Integer starCount, @NonNull List<InputPaidMedia> media, String caption, String parseMode, List<MessageEntity> captionEntities, Boolean showCaptionAboveMedia, Boolean disableNotification, Boolean protectContent, ReplyParameters replyParameters, ReplyKeyboard replyMarkup) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.starCount = starCount;
        this.media = media;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.replyMarkup = replyMarkup;
    }

    public static abstract class SendPaidMediaBuilder<C extends SendPaidMedia, B extends SendPaidMediaBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<ArrayList<Message>, C, B> {
        private String chatId;
        private Integer starCount;
        private List<InputPaidMedia> media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> captionEntities;
        private Boolean showCaptionAboveMedia;
        private Boolean disableNotification;
        private Boolean protectContent;
        private ReplyParameters replyParameters;
        private ReplyKeyboard replyMarkup;

        public SendPaidMediaBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        public B starCount(@NonNull Integer starCount) {
            if (starCount == null) {
                throw new NullPointerException("starCount is marked non-null but is null");
            }
            this.starCount = starCount;
            return (B)this.self();
        }

        public B media(@NonNull List<InputPaidMedia> media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        public B captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return (B)this.self();
        }

        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SendPaidMedia.SendPaidMediaBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", starCount=" + this.starCount + ", media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SendPaidMediaBuilderImpl
    extends SendPaidMediaBuilder<SendPaidMedia, SendPaidMediaBuilderImpl> {
        private SendPaidMediaBuilderImpl() {
        }

        @Override
        protected SendPaidMediaBuilderImpl self() {
            return this;
        }

        @Override
        public SendPaidMedia build() {
            return new SendPaidMedia(this);
        }
    }
}

