/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.ActionType;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SendChatActionBuilderImpl.class)
public class SendChatAction
extends BotApiMethodBoolean {
    public static final String PATH = "sendChatAction";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String ACTION_FIELD = "action";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="action")
    @NonNull
    private String action;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @JsonIgnore
    public ActionType getActionType() {
        return ActionType.get(this.action);
    }

    @JsonIgnore
    public void setAction(ActionType action) {
        this.action = action.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.action.isEmpty()) {
            throw new TelegramApiValidationException("Action parameter can't be empty", this);
        }
    }

    @Generated
    protected SendChatAction(SendChatActionBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.action = b.action;
        if (this.action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.businessConnectionId = b.businessConnectionId;
    }

    @Generated
    public static SendChatActionBuilder<?, ?> builder() {
        return new SendChatActionBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendChatAction)) {
            return false;
        }
        SendChatAction other = (SendChatAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendChatAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public String toString() {
        return "SendChatAction(chatId=" + this.getChatId() + ", action=" + this.getAction() + ", messageThreadId=" + this.getMessageThreadId() + ", businessConnectionId=" + this.getBusinessConnectionId() + ")";
    }

    @Generated
    public SendChatAction(@NonNull String chatId, @NonNull String action) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.chatId = chatId;
        this.action = action;
    }

    public static abstract class SendChatActionBuilder<C extends SendChatAction, B extends SendChatActionBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private String action;
        @Generated
        private Integer messageThreadId;
        @Generated
        private String businessConnectionId;

        public SendChatActionBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="action")
        @Generated
        public B action(@NonNull String action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendChatAction.SendChatActionBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", action=" + this.action + ", messageThreadId=" + this.messageThreadId + ", businessConnectionId=" + this.businessConnectionId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendChatActionBuilderImpl
    extends SendChatActionBuilder<SendChatAction, SendChatActionBuilderImpl> {
        @Generated
        private SendChatActionBuilderImpl() {
        }

        @Override
        @Generated
        protected SendChatActionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendChatAction build() {
            return new SendChatAction(this);
        }
    }
}

