/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.commands.BotCommand;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetMyCommands
extends BotApiMethodBoolean {
    public static final String PATH = "setMyCommands";
    private static final String COMMANDS_FIELD = "commands";
    private static final String SCOPE_FIELD = "scope";
    private static final String LANGUAGECODE_FIELD = "language_code";
    @JsonProperty(value="commands")
    @NonNull
    private List<BotCommand> commands;
    @JsonProperty(value="scope")
    private BotCommandScope scope;
    @JsonProperty(value="language_code")
    private String languageCode;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.languageCode != null && this.languageCode.isEmpty()) {
            throw new TelegramApiValidationException("LanguageCode parameter can't be empty string", this);
        }
        if (this.commands.isEmpty()) {
            throw new TelegramApiValidationException("Commands parameter can't be empty", this);
        }
        if (this.commands.size() > 100) {
            throw new TelegramApiValidationException("No more than 100 commands are allowed", this);
        }
        for (BotCommand command : this.commands) {
            command.validate();
        }
        if (this.scope != null) {
            this.scope.validate();
        }
    }

    public static SetMyCommandsBuilder builder() {
        return new SetMyCommandsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMyCommands)) {
            return false;
        }
        SetMyCommands other = (SetMyCommands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BotCommand> this$commands = this.getCommands();
        List<BotCommand> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        BotCommandScope this$scope = this.getScope();
        BotCommandScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$languageCode = this.getLanguageCode();
        String other$languageCode = other.getLanguageCode();
        return !(this$languageCode == null ? other$languageCode != null : !this$languageCode.equals(other$languageCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMyCommands;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BotCommand> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        BotCommandScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $languageCode = this.getLanguageCode();
        result = result * 59 + ($languageCode == null ? 43 : $languageCode.hashCode());
        return result;
    }

    @NonNull
    public List<BotCommand> getCommands() {
        return this.commands;
    }

    public BotCommandScope getScope() {
        return this.scope;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="commands")
    public void setCommands(@NonNull List<BotCommand> commands) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
    }

    @JsonProperty(value="scope")
    public void setScope(BotCommandScope scope) {
        this.scope = scope;
    }

    @JsonProperty(value="language_code")
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String toString() {
        return "SetMyCommands(commands=" + this.getCommands() + ", scope=" + this.getScope() + ", languageCode=" + this.getLanguageCode() + ")";
    }

    public SetMyCommands() {
    }

    public SetMyCommands(@NonNull List<BotCommand> commands, BotCommandScope scope, String languageCode) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
        this.scope = scope;
        this.languageCode = languageCode;
    }

    public static class SetMyCommandsBuilder {
        private ArrayList<BotCommand> commands;
        private BotCommandScope scope;
        private String languageCode;

        SetMyCommandsBuilder() {
        }

        public SetMyCommandsBuilder command(BotCommand command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        @JsonProperty(value="commands")
        public SetMyCommandsBuilder commands(Collection<? extends BotCommand> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public SetMyCommandsBuilder clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return this;
        }

        @JsonProperty(value="scope")
        public SetMyCommandsBuilder scope(BotCommandScope scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="language_code")
        public SetMyCommandsBuilder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public SetMyCommands build() {
            List<BotCommand> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<BotCommand>(this.commands));
                }
            }
            return new SetMyCommands(commands, this.scope, this.languageCode);
        }

        public String toString() {
            return "SetMyCommands.SetMyCommandsBuilder(commands=" + this.commands + ", scope=" + this.scope + ", languageCode=" + this.languageCode + ")";
        }
    }
}

