/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class BanChatSenderChat
extends BotApiMethod<Boolean> {
    public static final String PATH = "banChatSenderChat";
    private static final String CHATID_FIELD = "chat_id";
    private static final String SENDER_CHAT_ID_FIELD = "sender_chat_id";
    private static final String UNTILDATE_FIELD = "until_date";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="sender_chat_id")
    @NonNull
    private Long senderChatId;
    @JsonProperty(value="until_date")
    private Integer untilDate;

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error banning chat sender", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.senderChatId == 0L) {
            throw new TelegramApiValidationException("SenderChatId can't be null or 0", this);
        }
    }

    public static BanChatSenderChatBuilder builder() {
        return new BanChatSenderChatBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanChatSenderChat)) {
            return false;
        }
        BanChatSenderChat other = (BanChatSenderChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$senderChatId = this.getSenderChatId();
        Long other$senderChatId = other.getSenderChatId();
        if (this$senderChatId == null ? other$senderChatId != null : !((Object)this$senderChatId).equals(other$senderChatId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BanChatSenderChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $senderChatId = this.getSenderChatId();
        result = result * 59 + ($senderChatId == null ? 43 : ((Object)$senderChatId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getSenderChatId() {
        return this.senderChatId;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="sender_chat_id")
    public void setSenderChatId(@NonNull Long senderChatId) {
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.senderChatId = senderChatId;
    }

    @JsonProperty(value="until_date")
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    public String toString() {
        return "BanChatSenderChat(chatId=" + this.getChatId() + ", senderChatId=" + this.getSenderChatId() + ", untilDate=" + this.getUntilDate() + ")";
    }

    public BanChatSenderChat() {
    }

    public BanChatSenderChat(@NonNull String chatId, @NonNull Long senderChatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.senderChatId = senderChatId;
    }

    public BanChatSenderChat(@NonNull String chatId, @NonNull Long senderChatId, Integer untilDate) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (senderChatId == null) {
            throw new NullPointerException("senderChatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.senderChatId = senderChatId;
        this.untilDate = untilDate;
    }

    public static class BanChatSenderChatBuilder {
        private String chatId;
        private Long senderChatId;
        private Integer untilDate;

        BanChatSenderChatBuilder() {
        }

        @JsonProperty(value="chat_id")
        public BanChatSenderChatBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="sender_chat_id")
        public BanChatSenderChatBuilder senderChatId(@NonNull Long senderChatId) {
            if (senderChatId == null) {
                throw new NullPointerException("senderChatId is marked non-null but is null");
            }
            this.senderChatId = senderChatId;
            return this;
        }

        @JsonProperty(value="until_date")
        public BanChatSenderChatBuilder untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return this;
        }

        public BanChatSenderChat build() {
            return new BanChatSenderChat(this.chatId, this.senderChatId, this.untilDate);
        }

        public String toString() {
            return "BanChatSenderChat.BanChatSenderChatBuilder(chatId=" + this.chatId + ", senderChatId=" + this.senderChatId + ", untilDate=" + this.untilDate + ")";
        }
    }
}

