/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updates;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.WebhookInfo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetWebhookInfo
extends BotApiMethod<WebhookInfo> {
    public static final String PATH = "getwebhookinfo";

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public WebhookInfo deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<WebhookInfo>>(){});
            if (result.getOk().booleanValue()) {
                return (WebhookInfo)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting webhook info", result);
        }
        catch (IOException e2) {
            throw new TelegramApiRequestException("Unable to deserialize response", e2);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
    }

    public static GetWebhookInfoBuilder builder() {
        return new GetWebhookInfoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetWebhookInfo)) {
            return false;
        }
        GetWebhookInfo other = (GetWebhookInfo)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetWebhookInfo;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "GetWebhookInfo()";
    }

    public static class GetWebhookInfoBuilder {
        GetWebhookInfoBuilder() {
        }

        public GetWebhookInfo build() {
            return new GetWebhookInfo();
        }

        public String toString() {
            return "GetWebhookInfo.GetWebhookInfoBuilder()";
        }
    }
}

