/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultLocation
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String THUMBURL_FIELD = "thumb_url";
    private static final String THUMBWIDTH_FIELD = "thumb_width";
    private static final String THUMBHEIGHT_FIELD = "thumb_height";
    private static final String LIVEPERIOD_FIELD = "live_period";
    private static final String HORIZONTALACCURACY_FIELD = "horizontal_accuracy";
    private static final String HEADING_FIELD = "heading";
    private static final String APPROACHINGNOTIFICATIONDISTANCE_FIELD = "approaching_notification_distance";
    @JsonProperty(value="type")
    private final String type = "location";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="latitude")
    @NonNull
    private Float latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Float longitude;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_width")
    private Integer thumbWidth;
    @JsonProperty(value="thumb_height")
    private Integer thumbHeight;
    @JsonProperty(value="live_period")
    private Integer livePeriod;
    @JsonProperty(value="horizontal_accuracy")
    private Double horizontalAccuracy;
    @JsonProperty(value="heading")
    private Integer heading;
    @JsonProperty(value="approaching_notification_distance")
    private Integer approachingNotificationDistance;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.livePeriod != null && (this.livePeriod < 60 || this.livePeriod > 86400)) {
            throw new TelegramApiValidationException("Live period parameter must be between 60 and 86400", this);
        }
        if (this.horizontalAccuracy != null && (this.horizontalAccuracy < 0.0 || this.horizontalAccuracy > 1500.0)) {
            throw new TelegramApiValidationException("Horizontal Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.heading != null && (this.heading < 1 || this.heading > 360)) {
            throw new TelegramApiValidationException("Heading Accuracy parameter must be between 0 and 1500", this);
        }
        if (this.approachingNotificationDistance != null && (this.approachingNotificationDistance < 1 || this.approachingNotificationDistance > 100000)) {
            throw new TelegramApiValidationException("Approaching notification distance parameter must be between 0 and 1500", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultLocationBuilder builder() {
        return new InlineQueryResultLocationBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultLocation)) {
            return false;
        }
        InlineQueryResultLocation other = (InlineQueryResultLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$latitude = this.getLatitude();
        Float other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Float this$longitude = this.getLongitude();
        Float other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Integer this$thumbWidth = this.getThumbWidth();
        Integer other$thumbWidth = other.getThumbWidth();
        if (this$thumbWidth == null ? other$thumbWidth != null : !((Object)this$thumbWidth).equals(other$thumbWidth)) {
            return false;
        }
        Integer this$thumbHeight = this.getThumbHeight();
        Integer other$thumbHeight = other.getThumbHeight();
        if (this$thumbHeight == null ? other$thumbHeight != null : !((Object)this$thumbHeight).equals(other$thumbHeight)) {
            return false;
        }
        Integer this$livePeriod = this.getLivePeriod();
        Integer other$livePeriod = other.getLivePeriod();
        if (this$livePeriod == null ? other$livePeriod != null : !((Object)this$livePeriod).equals(other$livePeriod)) {
            return false;
        }
        Double this$horizontalAccuracy = this.getHorizontalAccuracy();
        Double other$horizontalAccuracy = other.getHorizontalAccuracy();
        if (this$horizontalAccuracy == null ? other$horizontalAccuracy != null : !((Object)this$horizontalAccuracy).equals(other$horizontalAccuracy)) {
            return false;
        }
        Integer this$heading = this.getHeading();
        Integer other$heading = other.getHeading();
        if (this$heading == null ? other$heading != null : !((Object)this$heading).equals(other$heading)) {
            return false;
        }
        Integer this$approachingNotificationDistance = this.getApproachingNotificationDistance();
        Integer other$approachingNotificationDistance = other.getApproachingNotificationDistance();
        if (this$approachingNotificationDistance == null ? other$approachingNotificationDistance != null : !((Object)this$approachingNotificationDistance).equals(other$approachingNotificationDistance)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        String this$thumbUrl = this.getThumbUrl();
        String other$thumbUrl = other.getThumbUrl();
        return !(this$thumbUrl == null ? other$thumbUrl != null : !this$thumbUrl.equals(other$thumbUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Float $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Integer $thumbWidth = this.getThumbWidth();
        result = result * 59 + ($thumbWidth == null ? 43 : ((Object)$thumbWidth).hashCode());
        Integer $thumbHeight = this.getThumbHeight();
        result = result * 59 + ($thumbHeight == null ? 43 : ((Object)$thumbHeight).hashCode());
        Integer $livePeriod = this.getLivePeriod();
        result = result * 59 + ($livePeriod == null ? 43 : ((Object)$livePeriod).hashCode());
        Double $horizontalAccuracy = this.getHorizontalAccuracy();
        result = result * 59 + ($horizontalAccuracy == null ? 43 : ((Object)$horizontalAccuracy).hashCode());
        Integer $heading = this.getHeading();
        result = result * 59 + ($heading == null ? 43 : ((Object)$heading).hashCode());
        Integer $approachingNotificationDistance = this.getApproachingNotificationDistance();
        result = result * 59 + ($approachingNotificationDistance == null ? 43 : ((Object)$approachingNotificationDistance).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        String $thumbUrl = this.getThumbUrl();
        result = result * 59 + ($thumbUrl == null ? 43 : $thumbUrl.hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public Float getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Float getLongitude() {
        return this.longitude;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public Integer getThumbWidth() {
        return this.thumbWidth;
    }

    public Integer getThumbHeight() {
        return this.thumbHeight;
    }

    public Integer getLivePeriod() {
        return this.livePeriod;
    }

    public Double getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public Integer getHeading() {
        return this.heading;
    }

    public Integer getApproachingNotificationDistance() {
        return this.approachingNotificationDistance;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Float latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Float longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="thumb_url")
    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    @JsonProperty(value="thumb_width")
    public void setThumbWidth(Integer thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    @JsonProperty(value="thumb_height")
    public void setThumbHeight(Integer thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    @JsonProperty(value="live_period")
    public void setLivePeriod(Integer livePeriod) {
        this.livePeriod = livePeriod;
    }

    @JsonProperty(value="horizontal_accuracy")
    public void setHorizontalAccuracy(Double horizontalAccuracy) {
        this.horizontalAccuracy = horizontalAccuracy;
    }

    @JsonProperty(value="heading")
    public void setHeading(Integer heading) {
        this.heading = heading;
    }

    @JsonProperty(value="approaching_notification_distance")
    public void setApproachingNotificationDistance(Integer approachingNotificationDistance) {
        this.approachingNotificationDistance = approachingNotificationDistance;
    }

    public String toString() {
        return "InlineQueryResultLocation(type=" + this.getType() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", replyMarkup=" + this.getReplyMarkup() + ", inputMessageContent=" + this.getInputMessageContent() + ", thumbUrl=" + this.getThumbUrl() + ", thumbWidth=" + this.getThumbWidth() + ", thumbHeight=" + this.getThumbHeight() + ", livePeriod=" + this.getLivePeriod() + ", horizontalAccuracy=" + this.getHorizontalAccuracy() + ", heading=" + this.getHeading() + ", approachingNotificationDistance=" + this.getApproachingNotificationDistance() + ")";
    }

    public InlineQueryResultLocation(@NonNull String id, @NonNull String title, @NonNull Float latitude, @NonNull Float longitude) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public InlineQueryResultLocation() {
    }

    public InlineQueryResultLocation(@NonNull String id, @NonNull String title, @NonNull Float latitude, @NonNull Float longitude, InlineKeyboardMarkup replyMarkup, InputMessageContent inputMessageContent, String thumbUrl, Integer thumbWidth, Integer thumbHeight, Integer livePeriod, Double horizontalAccuracy, Integer heading, Integer approachingNotificationDistance) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
        this.replyMarkup = replyMarkup;
        this.inputMessageContent = inputMessageContent;
        this.thumbUrl = thumbUrl;
        this.thumbWidth = thumbWidth;
        this.thumbHeight = thumbHeight;
        this.livePeriod = livePeriod;
        this.horizontalAccuracy = horizontalAccuracy;
        this.heading = heading;
        this.approachingNotificationDistance = approachingNotificationDistance;
    }

    public static class InlineQueryResultLocationBuilder {
        private String id;
        private String title;
        private Float latitude;
        private Float longitude;
        private InlineKeyboardMarkup replyMarkup;
        private InputMessageContent inputMessageContent;
        private String thumbUrl;
        private Integer thumbWidth;
        private Integer thumbHeight;
        private Integer livePeriod;
        private Double horizontalAccuracy;
        private Integer heading;
        private Integer approachingNotificationDistance;

        InlineQueryResultLocationBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultLocationBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultLocationBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="latitude")
        public InlineQueryResultLocationBuilder latitude(@NonNull Float latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="longitude")
        public InlineQueryResultLocationBuilder longitude(@NonNull Float longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultLocationBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultLocationBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="thumb_url")
        public InlineQueryResultLocationBuilder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        @JsonProperty(value="thumb_width")
        public InlineQueryResultLocationBuilder thumbWidth(Integer thumbWidth) {
            this.thumbWidth = thumbWidth;
            return this;
        }

        @JsonProperty(value="thumb_height")
        public InlineQueryResultLocationBuilder thumbHeight(Integer thumbHeight) {
            this.thumbHeight = thumbHeight;
            return this;
        }

        @JsonProperty(value="live_period")
        public InlineQueryResultLocationBuilder livePeriod(Integer livePeriod) {
            this.livePeriod = livePeriod;
            return this;
        }

        @JsonProperty(value="horizontal_accuracy")
        public InlineQueryResultLocationBuilder horizontalAccuracy(Double horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return this;
        }

        @JsonProperty(value="heading")
        public InlineQueryResultLocationBuilder heading(Integer heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(value="approaching_notification_distance")
        public InlineQueryResultLocationBuilder approachingNotificationDistance(Integer approachingNotificationDistance) {
            this.approachingNotificationDistance = approachingNotificationDistance;
            return this;
        }

        public InlineQueryResultLocation build() {
            return new InlineQueryResultLocation(this.id, this.title, this.latitude, this.longitude, this.replyMarkup, this.inputMessageContent, this.thumbUrl, this.thumbWidth, this.thumbHeight, this.livePeriod, this.horizontalAccuracy, this.heading, this.approachingNotificationDistance);
        }

        public String toString() {
            return "InlineQueryResultLocation.InlineQueryResultLocationBuilder(id=" + this.id + ", title=" + this.title + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyMarkup=" + this.replyMarkup + ", inputMessageContent=" + this.inputMessageContent + ", thumbUrl=" + this.thumbUrl + ", thumbWidth=" + this.thumbWidth + ", thumbHeight=" + this.thumbHeight + ", livePeriod=" + this.livePeriod + ", horizontalAccuracy=" + this.horizontalAccuracy + ", heading=" + this.heading + ", approachingNotificationDistance=" + this.approachingNotificationDistance + ")";
        }
    }
}

