/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatPermissions;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class RestrictChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "restrictchatmember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String CANSENDMESSAGES_FIELD = "can_send_messages";
    private static final String CANSENDMEDIAMESSAGES_FIELD = "can_send_media_messages";
    private static final String CANSENDOTHERMESSAGES_FIELD = "can_send_other_messages";
    private static final String CANADDWEBPAGEPREVIEWS_FIELD = "can_add_web_page_previews";
    private static final String PERMISSIONS_FIELD = "permissions";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Integer userId;
    @JsonProperty(value="permissions")
    @NonNull
    private ChatPermissions permissions;
    @JsonProperty(value="until_date")
    private Integer untilDate;

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error restricting chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be empty", this);
        }
        if (this.permissions == null) {
            throw new TelegramApiValidationException("Permissions can't be empty", this);
        }
    }

    public static RestrictChatMemberBuilder builder() {
        return new RestrictChatMemberBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestrictChatMember)) {
            return false;
        }
        RestrictChatMember other = (RestrictChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        ChatPermissions this$permissions = this.getPermissions();
        ChatPermissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestrictChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        ChatPermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getUserId() {
        return this.userId;
    }

    @NonNull
    public ChatPermissions getPermissions() {
        return this.permissions;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Integer userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(@NonNull ChatPermissions permissions) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.permissions = permissions;
    }

    @JsonProperty(value="until_date")
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    public String toString() {
        return "RestrictChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", permissions=" + this.getPermissions() + ", untilDate=" + this.getUntilDate() + ")";
    }

    public RestrictChatMember() {
    }

    public RestrictChatMember(@NonNull String chatId, @NonNull Integer userId, @NonNull ChatPermissions permissions) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.permissions = permissions;
    }

    public RestrictChatMember(@NonNull String chatId, @NonNull Integer userId, @NonNull ChatPermissions permissions, Integer untilDate) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.permissions = permissions;
        this.untilDate = untilDate;
    }

    public static class RestrictChatMemberBuilder {
        private String chatId;
        private Integer userId;
        private ChatPermissions permissions;
        private Integer untilDate;

        RestrictChatMemberBuilder() {
        }

        @JsonProperty(value="chat_id")
        public RestrictChatMemberBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        public RestrictChatMemberBuilder userId(@NonNull Integer userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="permissions")
        public RestrictChatMemberBuilder permissions(@NonNull ChatPermissions permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = permissions;
            return this;
        }

        @JsonProperty(value="until_date")
        public RestrictChatMemberBuilder untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return this;
        }

        public RestrictChatMember build() {
            return new RestrictChatMember(this.chatId, this.userId, this.permissions, this.untilDate);
        }

        public String toString() {
            return "RestrictChatMember.RestrictChatMemberBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ", permissions=" + this.permissions + ", untilDate=" + this.untilDate + ")";
        }
    }
}

