/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorDataField
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FIELDNAME_FIELD = "field_name";
    private static final String DATAHASH_FIELD = "data_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    @NonNull
    private final String source = "data";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="field_name")
    @NonNull
    private String fieldName;
    @JsonProperty(value="data_hash")
    @NonNull
    private String dataHash;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new TelegramApiValidationException("Field Name parameter can't be empty", this);
        }
        if (this.dataHash == null || this.dataHash.isEmpty()) {
            throw new TelegramApiValidationException("Data hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public static PassportElementErrorDataFieldBuilder builder() {
        return new PassportElementErrorDataFieldBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorDataField)) {
            return false;
        }
        PassportElementErrorDataField other = (PassportElementErrorDataField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$dataHash = this.getDataHash();
        String other$dataHash = other.getDataHash();
        if (this$dataHash == null ? other$dataHash != null : !this$dataHash.equals(other$dataHash)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorDataField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $dataHash = this.getDataHash();
        result = result * 59 + ($dataHash == null ? 43 : $dataHash.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @NonNull
    public String getSource() {
        return this.source;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    public String getDataHash() {
        return this.dataHash;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="field_name")
    public void setFieldName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.fieldName = fieldName;
    }

    @JsonProperty(value="data_hash")
    public void setDataHash(@NonNull String dataHash) {
        if (dataHash == null) {
            throw new NullPointerException("dataHash is marked non-null but is null");
        }
        this.dataHash = dataHash;
    }

    @JsonProperty(value="message")
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public String toString() {
        return "PassportElementErrorDataField(source=" + this.getSource() + ", type=" + this.getType() + ", fieldName=" + this.getFieldName() + ", dataHash=" + this.getDataHash() + ", message=" + this.getMessage() + ")";
    }

    public PassportElementErrorDataField() {
    }

    public PassportElementErrorDataField(@NonNull String type, @NonNull String fieldName, @NonNull String dataHash, @NonNull String message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (dataHash == null) {
            throw new NullPointerException("dataHash is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.fieldName = fieldName;
        this.dataHash = dataHash;
        this.message = message;
    }

    public static class PassportElementErrorDataFieldBuilder {
        private String type;
        private String fieldName;
        private String dataHash;
        private String message;

        PassportElementErrorDataFieldBuilder() {
        }

        @JsonProperty(value="type")
        public PassportElementErrorDataFieldBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @JsonProperty(value="field_name")
        public PassportElementErrorDataFieldBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        @JsonProperty(value="data_hash")
        public PassportElementErrorDataFieldBuilder dataHash(@NonNull String dataHash) {
            if (dataHash == null) {
                throw new NullPointerException("dataHash is marked non-null but is null");
            }
            this.dataHash = dataHash;
            return this;
        }

        @JsonProperty(value="message")
        public PassportElementErrorDataFieldBuilder message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        public PassportElementErrorDataField build() {
            return new PassportElementErrorDataField(this.type, this.fieldName, this.dataHash, this.message);
        }

        public String toString() {
            return "PassportElementErrorDataField.PassportElementErrorDataFieldBuilder(type=" + this.type + ", fieldName=" + this.fieldName + ", dataHash=" + this.dataHash + ", message=" + this.message + ")";
        }
    }
}

