/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetStickerSetThumb
extends BotApiMethod<Boolean> {
    private static final String PATH = "setStickerSetThumb";
    public static final String NAME_FIELD = "name";
    public static final String USERID_FIELD = "user_id";
    public static final String THUMB_FIELD = "thumb";
    private String name;
    private Integer userId;
    private InputFile thumb;

    public SetStickerSetThumb() {
    }

    public SetStickerSetThumb(String name, Integer userId, InputFile thumb) {
        this.name = name;
        this.userId = userId;
        this.thumb = thumb;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public SetStickerSetThumb setThumb(String thumb) {
        this.thumb = new InputFile(thumb);
        return this;
    }

    public SetStickerSetThumb setThumb(InputFile thumb) {
        this.thumb = thumb;
        return this;
    }

    public SetStickerSetThumb setThumb(File thumbFile) {
        this.thumb = new InputFile((File)Preconditions.checkNotNull((Object)thumbFile), thumbFile.getName());
        return this;
    }

    public SetStickerSetThumb setThumb(String thumbName, InputStream thumbStream) {
        this.thumb = new InputFile((InputStream)Preconditions.checkNotNull((Object)thumbStream), (String)Preconditions.checkNotNull((Object)thumbName));
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting sticker thumb in set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be null", this);
        }
        if (this.userId == null || this.userId == 0) {
            throw new TelegramApiValidationException("userId can't be null", this);
        }
        if (this.thumb == null) {
            throw new TelegramApiValidationException("thumb can't be null", this);
        }
        this.thumb.validate();
    }

    public String toString() {
        return "SetStickerSetThumb{name='" + this.name + '\'' + ", userId=" + this.userId + ", thumb=" + this.thumb + '}';
    }
}

