/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendAudio
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendaudio";
    public static final String DURATION_FIELD = "duration";
    public static final String CHATID_FIELD = "chat_id";
    public static final String AUDIO_FIELD = "audio";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PERFOMER_FIELD = "performer";
    public static final String TITLE_FIELD = "title";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String THUMB_FIELD = "thumb";
    private Integer duration;
    private String chatId;
    private InputFile audio;
    private Integer replyToMessageId;
    private Boolean disableNotification;
    private ReplyKeyboard replyMarkup;
    private String performer;
    private String title;
    private String caption;
    private String parseMode;
    private InputFile thumb;

    public Integer getDuration() {
        return this.duration;
    }

    public SendAudio setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendAudio setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendAudio setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public InputFile getAudio() {
        return this.audio;
    }

    public SendAudio setAudio(String audio) {
        this.audio = new InputFile(audio);
        return this;
    }

    public SendAudio setAudio(File file) {
        Objects.requireNonNull(file, "file cannot be null!");
        this.audio = new InputFile(file, file.getName());
        return this;
    }

    public SendAudio setAudio(String audioName, InputStream inputStream) {
        Objects.requireNonNull(audioName, "audioName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.audio = new InputFile(inputStream, audioName);
        return this;
    }

    public SendAudio setAudio(InputFile audio) {
        Objects.requireNonNull(audio, "audio cannot be null!");
        this.audio = audio;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendAudio setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendAudio setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public String getPerformer() {
        return this.performer;
    }

    public SendAudio setPerformer(String performer) {
        this.performer = performer;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendAudio setTitle(String title) {
        this.title = title;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendAudio enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendAudio disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendAudio setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public SendAudio setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public SendAudio setThumb(InputFile thumb) {
        this.thumb = thumb;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending audio", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.audio == null) {
            throw new TelegramApiValidationException("Audio parameter can't be empty", this);
        }
        this.audio.validate();
        if (this.thumb != null) {
            this.thumb.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendAudio{duration=" + this.duration + ", chatId='" + this.chatId + '\'' + ", audio=" + this.audio + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", replyMarkup=" + this.replyMarkup + ", performer='" + this.performer + '\'' + ", title='" + this.title + '\'' + ", caption='" + this.caption + '\'' + ", parseMode='" + this.parseMode + '\'' + ", thumb=" + this.thumb + '}';
    }
}

